/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.kodatimes.ranges;

import com.github.debop.kodatimes.ranges.InstantProgressionIterator;
import com.github.debop.kodatimes.ranges.JodaTimeProgression;
import com.github.debop.kodatimes.ranges.ProgressionsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u000eB\u001f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0096\u0002R\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/github/debop/kodatimes/ranges/InstantProgression;", "Lcom/github/debop/kodatimes/ranges/JodaTimeProgression;", "Lorg/joda/time/Instant;", "", "start", "endInclusive", "step", "Lorg/joda/time/Duration;", "(Lorg/joda/time/Instant;Lorg/joda/time/Instant;Lorg/joda/time/Duration;)V", "last", "getLast", "()Lorg/joda/time/Instant;", "iterator", "", "Companion", "koda-time"})
public class InstantProgression
extends JodaTimeProgression<Instant>
implements Iterable<Instant>,
KMappedMarker {
    @NotNull
    private final Instant last;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Instant getLast() {
        return this.last;
    }

    @Override
    @NotNull
    public Iterator<Instant> iterator() {
        return new InstantProgressionIterator((Instant)this.getFirst(), this.getLast(), this.getStep());
    }

    public InstantProgression(@NotNull Instant start, @NotNull Instant endInclusive, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)endInclusive, (String)"endInclusive");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        super((ReadableInstant)start, (ReadableInstant)endInclusive, (ReadableDuration)step2);
        this.last = ProgressionsKt.getProgressionLastElement(start, endInclusive, (ReadableDuration)step2);
    }

    @JvmStatic
    @NotNull
    public static final InstantProgression fromClosedRange(@NotNull Instant rangeStart, @NotNull Instant rangeEnd, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull((Object)rangeStart, (String)"rangeStart");
        Intrinsics.checkParameterIsNotNull((Object)rangeEnd, (String)"rangeEnd");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        return Companion.fromClosedRange(rangeStart, rangeEnd, step2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/github/debop/kodatimes/ranges/InstantProgression$Companion;", "", "()V", "fromClosedRange", "Lcom/github/debop/kodatimes/ranges/InstantProgression;", "rangeStart", "Lorg/joda/time/Instant;", "rangeEnd", "step", "Lorg/joda/time/Duration;", "koda-time"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final InstantProgression fromClosedRange(@NotNull Instant rangeStart, @NotNull Instant rangeEnd, @NotNull Duration step2) {
            Intrinsics.checkParameterIsNotNull((Object)rangeStart, (String)"rangeStart");
            Intrinsics.checkParameterIsNotNull((Object)rangeEnd, (String)"rangeEnd");
            Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
            return new InstantProgression(rangeStart, rangeEnd, step2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

