/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.ranges.DateProgressionIterator;
import com.github.debop.javatimes.ranges.ProgressionsKt;
import java.time.Duration;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001eB\u001f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00028\u00008\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/github/debop/javatimes/ranges/DateProgression;", "T", "Ljava/util/Date;", "", "start", "endInclusive", "step", "Ljava/time/Duration;", "(Ljava/util/Date;Ljava/util/Date;Ljava/time/Duration;)V", "first", "getFirst", "()Ljava/util/Date;", "Ljava/util/Date;", "last", "last$annotations", "()V", "getLast", "getStep", "()Ljava/time/Duration;", "equals", "", "other", "", "hashCode", "", "isEmpty", "iterator", "", "toString", "", "Companion", "koda-time"})
public class DateProgression<T extends Date>
implements Iterable<T>,
KMappedMarker {
    @NotNull
    private final T first;
    @NotNull
    private final T last;
    @NotNull
    private final Duration step;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final T getFirst() {
        return this.first;
    }

    public static /* synthetic */ void last$annotations() {
    }

    @NotNull
    public final T getLast() {
        return this.last;
    }

    public boolean isEmpty() {
        return this.step.compareTo(Duration.ZERO) > 0 ? ((Date)this.first).compareTo((Date)this.last) > 0 : ((Date)this.first).compareTo((Date)this.last) < 0;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new DateProgressionIterator<T>(this.first, this.last, this.step);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DateProgression && (this.isEmpty() && ((DateProgression)other).isEmpty() || Intrinsics.areEqual(this.first, ((DateProgression)other).first) && Intrinsics.areEqual(this.last, ((DateProgression)other).last) && Intrinsics.areEqual((Object)this.step, (Object)((DateProgression)other).step));
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : Objects.hash(this.first, this.last, this.step);
    }

    @NotNull
    public String toString() {
        return this.step.compareTo(Duration.ZERO) > 0 ? "" + this.first + ".." + this.last + " step " + this.step : "" + this.first + " downTo " + this.last + " step " + this.step.negated();
    }

    @NotNull
    public final Duration getStep() {
        return this.step;
    }

    public DateProgression(@NotNull T start, @NotNull T endInclusive, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(endInclusive, (String)"endInclusive");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        this.step = step2;
        boolean bl = Intrinsics.areEqual((Object)this.step, (Object)Duration.ZERO) ^ true;
        if (!bl) {
            String string = "step must be non-zero";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.first = start;
        Date date = ProgressionsKt.getProgressionLastElement(start, endInclusive, this.step);
        if (date == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        this.last = date;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T extends Date> DateProgression<T> fromClosedRange(@NotNull T start, @NotNull T endInclusive, @NotNull Duration step2) {
        return Companion.fromClosedRange(start, endInclusive, step2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T extends Date> DateProgression<T> fromClosedRange(@NotNull T start, @NotNull T endInclusive) {
        return com.github.debop.javatimes.ranges.DateProgression$Companion.fromClosedRange$default(Companion, start, endInclusive, null, 4, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/github/debop/javatimes/ranges/DateProgression$Companion;", "", "()V", "fromClosedRange", "Lcom/github/debop/javatimes/ranges/DateProgression;", "T", "Ljava/util/Date;", "start", "endInclusive", "step", "Ljava/time/Duration;", "(Ljava/util/Date;Ljava/util/Date;Ljava/time/Duration;)Lcom/github/debop/javatimes/ranges/DateProgression;", "koda-time"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final <T extends Date> DateProgression<T> fromClosedRange(@NotNull T start, @NotNull T endInclusive, @NotNull Duration step2) {
            Intrinsics.checkParameterIsNotNull(start, (String)"start");
            Intrinsics.checkParameterIsNotNull(endInclusive, (String)"endInclusive");
            Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
            return new DateProgression<T>(start, endInclusive, step2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ DateProgression fromClosedRange$default(Companion companion, Date date, Date date2, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                Duration duration2 = Duration.ofMillis(1L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMillis(1L)");
                duration = duration2;
            }
            return companion.fromClosedRange(date, date2, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final <T extends Date> DateProgression<T> fromClosedRange(@NotNull T start, @NotNull T endInclusive) {
            return com.github.debop.javatimes.ranges.DateProgression$Companion.fromClosedRange$default(this, start, endInclusive, null, 4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

