/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.DateIterator;
import com.github.debop.javatimes.JavatimexKt;
import java.time.Duration;
import java.util.Date;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\r\u0010\u0012\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u0013R\u0010\u0010\t\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/debop/javatimes/ranges/DateProgressionIterator;", "T", "Ljava/util/Date;", "Lcom/github/debop/javatimes/DateIterator;", "first", "last", "step", "Ljava/time/Duration;", "(Ljava/util/Date;Ljava/util/Date;Ljava/time/Duration;)V", "finalElement", "Ljava/util/Date;", "hasNext", "", "next", "getStep", "()Ljava/time/Duration;", "stepMillis", "", "nextDate", "()Ljava/util/Date;", "koda-time"})
public final class DateProgressionIterator<T extends Date>
extends DateIterator<T> {
    private final long stepMillis;
    private final T finalElement;
    private boolean hasNext;
    private T next;
    @NotNull
    private final Duration step;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    @NotNull
    public T nextDate() {
        T value = this.next;
        if (Intrinsics.areEqual(value, this.finalElement)) {
            if (!this.hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this.hasNext = false;
        } else {
            Date date = JavatimexKt.plus(this.next, this.stepMillis);
            if (date == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            this.next = date;
        }
        return value;
    }

    @NotNull
    public final Duration getStep() {
        return this.step;
    }

    public DateProgressionIterator(@NotNull T first, @NotNull T last, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull(first, (String)"first");
        Intrinsics.checkParameterIsNotNull(last, (String)"last");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        this.step = step2;
        this.stepMillis = this.step.toMillis();
        this.finalElement = last;
        this.hasNext = this.step.compareTo(Duration.ZERO) > 0 ? ((Date)first).compareTo((Date)last) <= 0 : ((Date)first).compareTo((Date)last) >= 0;
        this.next = this.hasNext ? first : this.finalElement;
    }
}

