/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.TemporalIterator;
import java.time.Duration;
import java.time.Instant;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\nH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/github/debop/javatimes/ranges/InstantProgressionIterator;", "Lcom/github/debop/javatimes/TemporalIterator;", "Ljava/time/Instant;", "first", "last", "step", "Ljava/time/Duration;", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Duration;)V", "_finalElement", "_hasNext", "", "_next", "getStep", "()Ljava/time/Duration;", "hasNext", "nextTemporal", "koda-time"})
public final class InstantProgressionIterator
extends TemporalIterator<Instant> {
    private final Instant _finalElement;
    private boolean _hasNext;
    private Instant _next;
    @NotNull
    private final Duration step;

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    @NotNull
    public Instant nextTemporal() {
        Instant value = this._next;
        if (Intrinsics.areEqual((Object)value, (Object)this._finalElement)) {
            if (!this._hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this._hasNext = false;
        } else {
            Instant instant = this._next.plus(this.step);
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"_next.plus(step)");
            this._next = instant;
        }
        return value;
    }

    @NotNull
    public final Duration getStep() {
        return this.step;
    }

    public InstantProgressionIterator(@NotNull Instant first, @NotNull Instant last, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)last, (String)"last");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        this.step = step2;
        this._finalElement = last;
        this._hasNext = this.step.compareTo(Duration.ZERO) > 0 ? first.compareTo(last) <= 0 : first.compareTo(last) >= 0;
        this._next = this._hasNext ? first : this._finalElement;
    }

    public /* synthetic */ InstantProgressionIterator(Instant instant, Instant instant2, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMillis(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMillis(1L)");
            duration = duration2;
        }
        this(instant, instant2, duration);
    }
}

