/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.JavatimexKt;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a \u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a9\u0010\u0006\u001a\u0002H\u0007\"\u0012\b\u0000\u0010\u0007*\u00020\b*\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u0002H\u00072\u0006\u0010\u000b\u001a\u0002H\u00072\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\u0010\u000e\u001a \u0010\u0006\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a \u0010\u0006\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0005H\u0002*\u0016\u0010\u0012\"\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0012\u0004\u0012\u00020\u00140\u0013*\u0016\u0010\u0015\"\b\u0012\u0004\u0012\u00020\u00160\u00132\b\u0012\u0004\u0012\u00020\u00160\u0013*\u0016\u0010\u0017\"\b\u0012\u0004\u0012\u00020\u00180\u00132\b\u0012\u0004\u0012\u00020\u00180\u0013*\u0016\u0010\u0019\"\b\u0012\u0004\u0012\u00020\u001a0\u00132\b\u0012\u0004\u0012\u00020\u001a0\u0013*\u0016\u0010\u001b\"\b\u0012\u0004\u0012\u00020\u001c0\u00132\b\u0012\u0004\u0012\u00020\u001c0\u0013\u00a8\u0006\u001d"}, d2={"differenceModulo", "", "a", "b", "c", "", "getProgressionLastElement", "T", "Ljava/time/temporal/Temporal;", "", "start", "end", "step", "Ljava/time/Duration;", "(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;Ljava/time/Duration;)Ljava/time/temporal/Temporal;", "Ljava/time/Instant;", "Ljava/util/Date;", "mod", "LocalDateProgression", "Lcom/github/debop/javatimes/ranges/TemporalProgression;", "Ljava/time/LocalDate;", "LocalDateTimeProgression", "Ljava/time/LocalDateTime;", "LocalTimeProgression", "Ljava/time/LocalTime;", "OffsetDateTimeProgression", "Ljava/time/OffsetDateTime;", "ZonedDateTimeProgression", "Ljava/time/ZonedDateTime;", "koda-time"})
public final class ProgressionsKt {
    private static final int mod(int a, int b) {
        int mod = a % b;
        return mod >= 0 ? mod : mod + b;
    }

    private static final long mod(long a, long b) {
        long mod = a % b;
        return mod >= 0L ? mod : mod + b;
    }

    private static final int differenceModulo(int a, int b, int c) {
        return ProgressionsKt.mod(ProgressionsKt.mod(a, c) - ProgressionsKt.mod(b, c), c);
    }

    private static final long differenceModulo(long a, long b, long c) {
        return ProgressionsKt.mod(ProgressionsKt.mod(a, c) - ProgressionsKt.mod(b, c), c);
    }

    @NotNull
    public static final Instant getProgressionLastElement(@NotNull Instant start, @NotNull Instant end, @NotNull Duration step2) {
        Instant instant;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        if (step2.compareTo(Duration.ZERO) > 0) {
            Instant instant2 = end.minusMillis(ProgressionsKt.differenceModulo(end.toEpochMilli(), start.toEpochMilli(), step2.toMillis()));
            instant = instant2;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"end.minusMillis(differen\u2026illi(), step.toMillis()))");
        } else if (step2.compareTo(Duration.ZERO) < 0) {
            Instant instant3 = end.plusMillis(ProgressionsKt.differenceModulo(start.toEpochMilli(), end.toEpochMilli(), -step2.toMillis()));
            instant = instant3;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant3, (String)"end.plusMillis(differenc\u2026lli(), -step.toMillis()))");
        } else {
            throw (Throwable)new IllegalArgumentException("step is zero.");
        }
        return instant;
    }

    @NotNull
    public static final Date getProgressionLastElement(@NotNull Date start, @NotNull Date end, @NotNull Duration step2) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        if (step2.compareTo(Duration.ZERO) > 0) {
            date = JavatimexKt.minus(end, ProgressionsKt.differenceModulo(end.getTime(), start.getTime(), step2.toMillis()));
        } else if (step2.compareTo(Duration.ZERO) < 0) {
            date = JavatimexKt.plus(end, ProgressionsKt.differenceModulo(start.getTime(), end.getTime(), -step2.toMillis()));
        } else {
            throw (Throwable)new IllegalArgumentException("step is zero.");
        }
        return date;
    }

    @NotNull
    public static final <T extends Temporal & Comparable<? super T>> T getProgressionLastElement(@NotNull T start, @NotNull T end, @NotNull Duration step2) {
        Temporal temporal;
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        if (step2.compareTo(Duration.ZERO) > 0) {
            temporal = end.minus(ProgressionsKt.differenceModulo(JavatimexKt.toEhpochMillis(end), JavatimexKt.toEhpochMillis(start), step2.toMillis()), ChronoUnit.MILLIS);
            if (temporal == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
        } else if (step2.compareTo(Duration.ZERO) < 0) {
            temporal = end.plus(ProgressionsKt.differenceModulo(JavatimexKt.toEhpochMillis(start), JavatimexKt.toEhpochMillis(end), -step2.toMillis()), ChronoUnit.MILLIS);
            if (temporal == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
        } else {
            throw (Throwable)new IllegalArgumentException("step is zero");
        }
        return (T)temporal;
    }
}

