/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.ranges.ProgressionsKt;
import com.github.debop.javatimes.ranges.TemporalProgressionIterator;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.Iterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001d*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001\u001dB!\b\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\n\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/github/debop/javatimes/ranges/TemporalProgression;", "T", "Ljava/time/temporal/Temporal;", "", "", "start", "endInclusive", "step", "Ljava/time/Duration;", "(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;Ljava/time/Duration;)V", "first", "getFirst", "()Ljava/time/temporal/Temporal;", "Ljava/time/temporal/Temporal;", "last", "getLast", "getStep", "()Ljava/time/Duration;", "equals", "", "other", "", "hashCode", "", "isEmpty", "iterator", "", "toString", "", "Companion", "koda-time"})
public class TemporalProgression<T extends Temporal & Comparable<? super T>>
implements Iterable<T>,
KMappedMarker {
    @NotNull
    private final T first;
    @NotNull
    private final T last;
    @NotNull
    private final Duration step;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final T getFirst() {
        return this.first;
    }

    @NotNull
    public final T getLast() {
        return this.last;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new TemporalProgressionIterator<T>(this.first, this.last, this.step);
    }

    public boolean isEmpty() {
        return this.step.compareTo(Duration.ZERO) > 0 ? ((Comparable)this.first).compareTo(this.last) > 0 : ((Comparable)this.first).compareTo(this.last) < 0;
    }

    public boolean equals(@Nullable Object other) {
        return !(other instanceof TemporalProgression) ? false : this.isEmpty() && ((TemporalProgression)other).isEmpty() || Intrinsics.areEqual(this.first, ((TemporalProgression)other).first) && Intrinsics.areEqual(this.last, ((TemporalProgression)other).last) && Intrinsics.areEqual((Object)this.step, (Object)((TemporalProgression)other).step);
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : Objects.hash(this.first, this.last, this.step);
    }

    @NotNull
    public String toString() {
        return Intrinsics.areEqual((Object)this.step, (Object)Duration.ZERO) ? "" + this.first + ".." + this.last : (this.step.compareTo(Duration.ZERO) > 0 ? "" + this.first + ".." + this.last + " step " + this.step : "" + this.first + " downTo " + this.last + " step " + this.step.negated());
    }

    @NotNull
    public final Duration getStep() {
        return this.step;
    }

    public TemporalProgression(@NotNull T start, @NotNull T endInclusive, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(endInclusive, (String)"endInclusive");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        this.step = step2;
        boolean bl = Intrinsics.areEqual((Object)this.step, (Object)Duration.ZERO) ^ true;
        if (!bl) {
            String string = "step should not be ZERO";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.first = start;
        this.last = ProgressionsKt.getProgressionLastElement(start, endInclusive, this.step);
    }

    public /* synthetic */ TemporalProgression(Temporal temporal, Temporal temporal2, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMillis(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMillis(1L)");
            duration = duration2;
        }
        this(temporal, temporal2, duration);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T extends Temporal & Comparable<? super T>> TemporalProgression<T> fromClosedRange(@NotNull T start, @NotNull T endInclusive, @NotNull Duration step2) {
        return Companion.fromClosedRange(start, endInclusive, step2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T extends Temporal & Comparable<? super T>> TemporalProgression<T> fromClosedRange(@NotNull T start, @NotNull T endInclusive) {
        return com.github.debop.javatimes.ranges.TemporalProgression$Companion.fromClosedRange$default(Companion, start, endInclusive, null, 4, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0012\b\u0001\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0006\u0010\t\u001a\u0002H\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/debop/javatimes/ranges/TemporalProgression$Companion;", "", "()V", "fromClosedRange", "Lcom/github/debop/javatimes/ranges/TemporalProgression;", "T", "Ljava/time/temporal/Temporal;", "", "start", "endInclusive", "step", "Ljava/time/Duration;", "(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;Ljava/time/Duration;)Lcom/github/debop/javatimes/ranges/TemporalProgression;", "koda-time"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final <T extends Temporal & Comparable<? super T>> TemporalProgression<T> fromClosedRange(@NotNull T start, @NotNull T endInclusive, @NotNull Duration step2) {
            Intrinsics.checkParameterIsNotNull(start, (String)"start");
            Intrinsics.checkParameterIsNotNull(endInclusive, (String)"endInclusive");
            Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
            return new TemporalProgression<T>(start, endInclusive, step2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ TemporalProgression fromClosedRange$default(Companion companion, Temporal temporal, Temporal temporal2, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                Duration duration2 = Duration.ofMillis(1L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMillis(1L)");
                duration = duration2;
            }
            return companion.fromClosedRange(temporal, temporal2, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final <T extends Temporal & Comparable<? super T>> TemporalProgression<T> fromClosedRange(@NotNull T start, @NotNull T endInclusive) {
            return com.github.debop.javatimes.ranges.TemporalProgression$Companion.fromClosedRange$default(this, start, endInclusive, null, 4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

