/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.TemporalIterator;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\rH\u0096\u0002J\r\u0010\u0012\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u0013R\u0010\u0010\n\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/github/debop/javatimes/ranges/TemporalProgressionIterator;", "T", "Ljava/time/temporal/Temporal;", "", "Lcom/github/debop/javatimes/TemporalIterator;", "first", "last", "step", "Ljava/time/Duration;", "(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;Ljava/time/Duration;)V", "_finalElement", "Ljava/time/temporal/Temporal;", "_hasNext", "", "_next", "getStep", "()Ljava/time/Duration;", "hasNext", "nextTemporal", "()Ljava/time/temporal/Temporal;", "koda-time"})
public final class TemporalProgressionIterator<T extends Temporal & Comparable<? super T>>
extends TemporalIterator<T> {
    private final T _finalElement;
    private boolean _hasNext;
    private T _next;
    @NotNull
    private final Duration step;

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    @NotNull
    public T nextTemporal() {
        T value = this._next;
        if (Intrinsics.areEqual(value, this._finalElement)) {
            if (!this._hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this._hasNext = false;
        } else {
            Temporal temporal = this._next.plus(this.step);
            if (temporal == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            this._next = temporal;
        }
        return value;
    }

    @NotNull
    public final Duration getStep() {
        return this.step;
    }

    public TemporalProgressionIterator(@NotNull T first, @NotNull T last, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull(first, (String)"first");
        Intrinsics.checkParameterIsNotNull(last, (String)"last");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        this.step = step2;
        this._finalElement = last;
        this._hasNext = this.step.compareTo(Duration.ZERO) > 0 ? ((Comparable)first).compareTo(last) <= 0 : ((Comparable)first).compareTo(last) >= 0;
        this._next = this._hasNext ? first : this._finalElement;
    }

    public /* synthetic */ TemporalProgressionIterator(Temporal temporal, Temporal temporal2, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMillis(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMillis(1L)");
            duration = duration2;
        }
        this(temporal, temporal2, duration);
    }
}

