/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.kodatimes.ranges;

import com.github.debop.kodatimes.JodaTimeIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/github/debop/kodatimes/ranges/DateTimeProgressionIterator;", "Lcom/github/debop/kodatimes/JodaTimeIterator;", "Lorg/joda/time/DateTime;", "first", "last", "step", "Lorg/joda/time/ReadableDuration;", "(Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Lorg/joda/time/ReadableDuration;)V", "finalElement", "hasNext", "", "next", "getStep", "()Lorg/joda/time/ReadableDuration;", "nextJodaTime", "koda-time"})
public final class DateTimeProgressionIterator
extends JodaTimeIterator<DateTime> {
    private final DateTime finalElement;
    private boolean hasNext;
    private DateTime next;
    @NotNull
    private final ReadableDuration step;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    @NotNull
    public DateTime nextJodaTime() {
        DateTime value = this.next;
        if (Intrinsics.areEqual((Object)value, (Object)this.finalElement)) {
            if (!this.hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this.hasNext = false;
        } else {
            this.next = this.next.plus(this.step);
        }
        return value;
    }

    @NotNull
    public final ReadableDuration getStep() {
        return this.step;
    }

    public DateTimeProgressionIterator(@NotNull DateTime first, @NotNull DateTime last, @NotNull ReadableDuration step2) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)last, (String)"last");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        this.step = step2;
        this.finalElement = last;
        this.hasNext = this.step.getMillis() > 0L ? first.compareTo((ReadableInstant)last) <= 0 : first.compareTo((ReadableInstant)last) >= 0;
        this.next = this.hasNext ? first : this.finalElement;
    }
}

