/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.kodatimes.ranges;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a \u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a \u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"differenceModulo", "", "a", "b", "c", "", "getProgressionLastElement", "Lorg/joda/time/DateTime;", "start", "end", "step", "Lorg/joda/time/ReadableDuration;", "Lorg/joda/time/Instant;", "mod", "koda-time"})
public final class ProgressionsKt {
    private static final int mod(int a, int b) {
        int mod = a % b;
        return mod >= 0 ? mod : mod + b;
    }

    private static final long mod(long a, long b) {
        long mod = a % b;
        return mod >= 0L ? mod : mod + b;
    }

    private static final int differenceModulo(int a, int b, int c) {
        return ProgressionsKt.mod(ProgressionsKt.mod(a, c) - ProgressionsKt.mod(b, c), c);
    }

    private static final long differenceModulo(long a, long b, long c) {
        return ProgressionsKt.mod(ProgressionsKt.mod(a, c) - ProgressionsKt.mod(b, c), c);
    }

    @NotNull
    public static final DateTime getProgressionLastElement(@NotNull DateTime start, @NotNull DateTime end, @NotNull ReadableDuration step2) {
        DateTime dateTime;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        if (step2.getMillis() > 0L) {
            DateTime dateTime2 = end.minus(ProgressionsKt.differenceModulo(end.getMillis(), start.getMillis(), step2.getMillis()));
            dateTime = dateTime2;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTime2, (String)"end - differenceModulo(e\u2026tart.millis, step.millis)");
        } else if (step2.getMillis() < 0L) {
            DateTime dateTime3 = end.plus(ProgressionsKt.differenceModulo(start.getMillis(), end.getMillis(), -step2.getMillis()));
            dateTime = dateTime3;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTime3, (String)"end + differenceModulo(s\u2026end.millis, -step.millis)");
        } else {
            throw (Throwable)new IllegalArgumentException("Step is zero.");
        }
        return dateTime;
    }

    @NotNull
    public static final Instant getProgressionLastElement(@NotNull Instant start, @NotNull Instant end, @NotNull ReadableDuration step2) {
        Instant instant;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        if (step2.getMillis() > 0L) {
            Instant instant2 = end.minus(ProgressionsKt.differenceModulo(end.getMillis(), start.getMillis(), step2.getMillis()));
            instant = instant2;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"end - differenceModulo(e\u2026tart.millis, step.millis)");
        } else if (step2.getMillis() < 0L) {
            Instant instant3 = end.plus(ProgressionsKt.differenceModulo(start.getMillis(), end.getMillis(), -step2.getMillis()));
            instant = instant3;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant3, (String)"end + differenceModulo(s\u2026end.millis, -step.millis)");
        } else {
            throw (Throwable)new IllegalArgumentException("Step is zero.");
        }
        return instant;
    }
}

