/*
 * Decompiled with CFR 0.152.
 */
package com.github.dmstocking.optional.java.util;

import com.github.dmstocking.optional.java.util.function.Consumer;
import com.github.dmstocking.optional.java.util.function.Function;
import com.github.dmstocking.optional.java.util.function.Predicate;
import com.github.dmstocking.optional.java.util.function.Supplier;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional<Object>(null);
    private final T value;

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    private Optional(T value) {
        this.value = value;
    }

    public static <T> Optional<T> of(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        if (value != null) {
            return new Optional<T>(value);
        }
        return Optional.empty();
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        if (this.isPresent() && predicate.test(this.value)) {
            return this;
        }
        return Optional.empty();
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        if (this.isPresent()) {
            return mapper.apply(this.value);
        }
        return Optional.empty();
    }

    public T get() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> consumer, Runnable emptyAction) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        if (this.isPresent()) {
            return Optional.ofNullable(mapper.apply(this.value));
        }
        return Optional.empty();
    }

    public Optional<T> or(Supplier<? extends Optional<? extends T>> supplier) {
        if (this.isPresent()) {
            return this;
        }
        if (supplier == null) {
            throw new NullPointerException();
        }
        Optional<? extends T> optional = supplier.get();
        if (optional == null) {
            throw new NullPointerException();
        }
        return optional;
    }

    public T orElse(T other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Optional)) {
            return false;
        }
        if (this.isPresent()) {
            Optional other = (Optional)o;
            return this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.isPresent()) {
            return this.value.hashCode();
        }
        return 0;
    }

    public String toString() {
        if (this.isPresent()) {
            return "Optional[" + this.value.toString() + "]";
        }
        return "Optional.empty";
    }
}

