/*
 * Decompiled with CFR 0.152.
 */
package com.github.dmstocking.optional.java.util;

import com.github.dmstocking.optional.java.util.function.IntConsumer;
import com.github.dmstocking.optional.java.util.function.IntSupplier;
import com.github.dmstocking.optional.java.util.function.Supplier;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionalInt {
    private static final OptionalInt EMPTY = new OptionalInt(false, 0);
    private boolean isPresent;
    private final int value;

    public static OptionalInt empty() {
        return EMPTY;
    }

    private OptionalInt(boolean isPresent, int value) {
        this.isPresent = isPresent;
        this.value = value;
    }

    public static OptionalInt of(int value) {
        return new OptionalInt(true, value);
    }

    public int getAsInt() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    public void ifPresent(IntConsumer consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(IntConsumer consumer, Runnable emptyAction) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public int orElse(int other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other;
    }

    public int orElseGet(IntSupplier other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other.get();
    }

    public <X extends Throwable> int orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionalInt)) {
            return false;
        }
        if (this.isPresent()) {
            OptionalInt other = (OptionalInt)o;
            return this.value == other.value;
        }
        return false;
    }

    public int hashCode() {
        if (this.isPresent()) {
            return Integer.hashCode(this.value);
        }
        return 0;
    }

    public String toString() {
        if (this.isPresent()) {
            return "OptionalInt[" + this.value + "]";
        }
        return "OptionalInt.empty";
    }
}

