/*
 * Decompiled with CFR 0.152.
 */
package com.github.dmstocking.optional.java.util;

import com.github.dmstocking.optional.java.util.function.LongConsumer;
import com.github.dmstocking.optional.java.util.function.LongSupplier;
import com.github.dmstocking.optional.java.util.function.Supplier;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionalLong {
    private static final OptionalLong EMPTY = new OptionalLong(false, 0L);
    private boolean isPresent;
    private final long value;

    public static OptionalLong empty() {
        return EMPTY;
    }

    private OptionalLong(boolean isPresent, long value) {
        this.isPresent = isPresent;
        this.value = value;
    }

    public static OptionalLong of(long value) {
        return new OptionalLong(true, value);
    }

    public long getAsLong() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    public void ifPresent(LongConsumer consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(LongConsumer consumer, Runnable emptyAction) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public long orElse(long other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other;
    }

    public long orElseGet(LongSupplier other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other.get();
    }

    public <X extends Throwable> long orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionalLong)) {
            return false;
        }
        if (this.isPresent()) {
            OptionalLong other = (OptionalLong)o;
            return this.value == other.value;
        }
        return false;
    }

    public int hashCode() {
        if (this.isPresent()) {
            return Long.hashCode(this.value);
        }
        return 0;
    }

    public String toString() {
        if (this.isPresent()) {
            return "OptionalLong[" + this.value + "]";
        }
        return "OptionalLong.empty";
    }
}

