/*
 * Decompiled with CFR 0.152.
 */
package com.github.dmstocking.optional.java.util;

import com.github.dmstocking.optional.java.util.function.DoubleConsumer;
import com.github.dmstocking.optional.java.util.function.DoubleSupplier;
import com.github.dmstocking.optional.java.util.function.Supplier;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionalDouble {
    private static final OptionalDouble EMPTY = new OptionalDouble(false, 0.0);
    private boolean isPresent;
    private final double value;

    public static OptionalDouble empty() {
        return EMPTY;
    }

    private OptionalDouble(boolean isPresent, double value) {
        this.isPresent = isPresent;
        this.value = value;
    }

    public static OptionalDouble of(double value) {
        return new OptionalDouble(true, value);
    }

    public double getAsDouble() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    public void ifPresent(DoubleConsumer consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(DoubleConsumer consumer, Runnable emptyAction) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public double orElse(double other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other;
    }

    public double orElseGet(DoubleSupplier other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other.get();
    }

    public <X extends Throwable> double orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionalDouble)) {
            return false;
        }
        if (this.isPresent()) {
            OptionalDouble other = (OptionalDouble)o;
            return this.value == other.value;
        }
        return false;
    }

    public int hashCode() {
        if (this.isPresent()) {
            return Double.hashCode(this.value);
        }
        return 0;
    }

    public String toString() {
        if (this.isPresent()) {
            return "OptionalDouble[" + this.value + "]";
        }
        return "OptionalDouble.empty";
    }
}

