/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.astuetz.PagerSlidingTabStrip;
import com.github.florent37.materialviewpager.MaterialViewPagerAnimator;
import com.github.florent37.materialviewpager.MaterialViewPagerHeader;
import com.github.florent37.materialviewpager.MaterialViewPagerHelper;
import com.github.florent37.materialviewpager.MaterialViewPagerImageHeader;
import com.github.florent37.materialviewpager.MaterialViewPagerSettings;
import com.github.florent37.materialviewpager.R;
import com.github.florent37.materialviewpager.Utils;

public class MaterialViewPager
extends FrameLayout {
    private ViewGroup headerBackgroundContainer;
    private ViewGroup pagerTitleStripContainer;
    private ViewGroup logoContainer;
    protected MaterialViewPagerHeader materialViewPagerHeader;
    protected Toolbar mToolbar;
    protected ViewPager mViewPager;
    protected View headerBackground;
    protected View toolbarLayoutBackground;
    protected MaterialViewPagerSettings settings = new MaterialViewPagerSettings();

    public MaterialViewPager(Context context) {
        super(context);
    }

    public MaterialViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.settings.handleAttributes(context, attrs);
    }

    public MaterialViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.settings.handleAttributes(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.settings.handleAttributes(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.material_view_pager_layout, (ViewGroup)this, false));
        this.headerBackgroundContainer = (ViewGroup)this.findViewById(R.id.headerBackgroundContainer);
        this.pagerTitleStripContainer = (ViewGroup)this.findViewById(R.id.pagerTitleStripContainer);
        this.logoContainer = (ViewGroup)this.findViewById(R.id.logoContainer);
        this.mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.mViewPager = (ViewPager)this.findViewById(R.id.viewPager);
        if (this.settings.headerLayoutId != -1) {
            this.headerBackgroundContainer.addView(LayoutInflater.from((Context)this.getContext()).inflate(this.settings.headerLayoutId, this.headerBackgroundContainer, false));
        }
        if (this.isInEditMode()) {
            this.settings.pagerTitleStripId = R.layout.tools_material_view_pager_pagertitlestrip;
        }
        if (this.settings.pagerTitleStripId != -1) {
            this.pagerTitleStripContainer.addView(LayoutInflater.from((Context)this.getContext()).inflate(this.settings.pagerTitleStripId, this.pagerTitleStripContainer, false));
        }
        if (this.settings.logoLayoutId != -1) {
            this.logoContainer.addView(LayoutInflater.from((Context)this.getContext()).inflate(this.settings.logoLayoutId, this.logoContainer, false));
            if (this.settings.logoMarginTop != 0) {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.logoContainer.getLayoutParams();
                layoutParams.setMargins(0, this.settings.logoMarginTop, 0, 0);
                this.logoContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.headerBackground = this.findViewById(R.id.headerBackground);
        this.toolbarLayoutBackground = this.findViewById(R.id.toolbar_layout_background);
        this.initialiseHeights();
        if (!this.isInEditMode()) {
            this.materialViewPagerHeader = MaterialViewPagerHeader.withToolbar(this.mToolbar).withToolbarLayoutBackground(this.toolbarLayoutBackground).withPagerSlidingTabStrip((View)this.pagerTitleStripContainer).withHeaderBackground(this.headerBackground).withStatusBackground(this.findViewById(R.id.statusBackground)).withLogo((View)this.logoContainer);
            MaterialViewPagerHelper.register((Activity)this.getContext(), new MaterialViewPagerAnimator(this));
        } else {
            View sample = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tools_list_items, this.pagerTitleStripContainer, false);
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)sample.getLayoutParams();
            int marginTop = Math.round(Utils.dpToPx(this.settings.headerHeight + 10, this.getContext()));
            params.setMargins(0, marginTop, 0, 0);
            super.setLayoutParams((ViewGroup.LayoutParams)params);
            this.addView(sample);
        }
    }

    private void initialiseHeights() {
        RelativeLayout.LayoutParams layoutParams;
        if (this.headerBackground != null) {
            this.headerBackground.setBackgroundColor(this.settings.color);
            layoutParams = this.headerBackground.getLayoutParams();
            layoutParams.height = (int)Utils.dpToPx(this.settings.headerHeight + 60, this.getContext());
            this.headerBackground.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (this.pagerTitleStripContainer != null) {
            layoutParams = (RelativeLayout.LayoutParams)this.pagerTitleStripContainer.getLayoutParams();
            int marginTop = (int)Utils.dpToPx(this.settings.headerHeight - 40, this.getContext());
            layoutParams.setMargins(0, marginTop, 0, 0);
            this.pagerTitleStripContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (this.toolbarLayoutBackground != null) {
            layoutParams = this.toolbarLayoutBackground.getLayoutParams();
            layoutParams.height = (int)Utils.dpToPx(this.settings.headerHeight, this.getContext());
            this.toolbarLayoutBackground.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public PagerSlidingTabStrip getPagerTitleStrip() {
        return (PagerSlidingTabStrip)this.pagerTitleStripContainer.findViewById(R.id.materialviewpager_pagerTitleStrip);
    }

    public Toolbar getToolbar() {
        return this.mToolbar;
    }

    public void setImageUrl(String imageUrl, int fadeDuration) {
        MaterialViewPagerImageHeader headerBackgroundImage;
        if (imageUrl != null && (headerBackgroundImage = (MaterialViewPagerImageHeader)this.findViewById(R.id.materialviewpager_imageHeader)) != null) {
            headerBackgroundImage.setImageUrl(imageUrl, fadeDuration);
        }
    }

    public void setImageDrawable(Drawable drawable2, int fadeDuration) {
        MaterialViewPagerImageHeader headerBackgroundImage;
        if (drawable2 != null && (headerBackgroundImage = (MaterialViewPagerImageHeader)this.findViewById(R.id.materialviewpager_imageHeader)) != null) {
            headerBackgroundImage.setImageDrawable(drawable2, fadeDuration);
        }
    }

    public void setColor(int color2, int fadeDuration) {
        MaterialViewPagerHelper.getAnimator(this.getContext()).setColor(color2, fadeDuration * 2);
    }
}

