/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.widget.ListView;
import android.widget.ScrollView;
import com.github.florent37.materialviewpager.MaterialViewPager;
import com.github.florent37.materialviewpager.MaterialViewPagerHeader;
import com.github.florent37.materialviewpager.MaterialViewPagerSettings;
import com.github.florent37.materialviewpager.Utils;
import com.github.ksoichiro.android.observablescrollview.ObservableListView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollViewCallbacks;
import com.github.ksoichiro.android.observablescrollview.ObservableWebView;
import com.github.ksoichiro.android.observablescrollview.ScrollState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MaterialViewPagerAnimator {
    private static final String TAG = MaterialViewPagerAnimator.class.getSimpleName();
    private Context context;
    private MaterialViewPagerHeader mHeader;
    private static final int ENTER_TOOLBAR_ANIMATION_DURATION = 600;
    private MaterialViewPager materialViewPager;
    public final float elevation;
    public final float scrollMax;
    public final float scrollMaxDp;
    private float lastYOffset = -1.0f;
    private float lastPercent = 0.0f;
    private MaterialViewPagerSettings settings;
    private float headerYOffset = Float.MAX_VALUE;
    private ObjectAnimator headerAnimator;
    private List<Object> scrollViewList = new ArrayList<Object>();
    private List<Object> calledScrollList = new ArrayList<Object>();
    private HashMap<Object, Integer> yOffsets = new HashMap();

    public MaterialViewPagerAnimator(MaterialViewPager materialViewPager) {
        this.settings = materialViewPager.settings;
        this.materialViewPager = materialViewPager;
        this.mHeader = materialViewPager.materialViewPagerHeader;
        this.context = this.mHeader.getContext();
        this.scrollMax = this.settings.headerHeight;
        this.scrollMaxDp = Utils.dpToPx(this.scrollMax, this.context);
        this.elevation = Utils.dpToPx(4.0f, this.context);
    }

    private void dispatchScrollOffset(Object source, float yOffset) {
        if (this.scrollViewList != null) {
            for (Object scroll : this.scrollViewList) {
                if (scroll == null || scroll == source) continue;
                this.calledScrollList.add(scroll);
                if (scroll instanceof RecyclerView) {
                    RecyclerView.LayoutManager layoutManager = ((RecyclerView)scroll).getLayoutManager();
                    if (layoutManager instanceof LinearLayoutManager) {
                        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
                        linearLayoutManager.scrollToPositionWithOffset(0, (int)(-yOffset));
                    }
                } else if (scroll instanceof ScrollView) {
                    ((ScrollView)scroll).scrollTo(0, (int)yOffset);
                } else if (scroll instanceof ListView) {
                    ((ListView)scroll).scrollTo(0, (int)yOffset);
                } else if (scroll instanceof WebView) {
                    ((WebView)scroll).scrollTo(0, (int)yOffset);
                }
                this.yOffsets.put(scroll, (int)yOffset);
                this.calledScrollList.remove(scroll);
            }
        }
    }

    public void onMaterialScrolled(Object source, float yOffset) {
        float newY;
        if (yOffset == this.lastYOffset) {
            return;
        }
        float scrollTop = -yOffset;
        if (this.mHeader.headerBackground != null) {
            this.mHeader.headerBackground.setTranslationY(scrollTop / 1.5f);
        }
        Log.d((String)"yOffset", (String)("" + yOffset));
        this.dispatchScrollOffset(source, MaterialViewPagerAnimator.minMax(0.0f, yOffset, this.scrollMaxDp));
        float percent = yOffset / this.scrollMax;
        percent = MaterialViewPagerAnimator.minMax(0.0f, percent, 1.0f);
        this.setColorPercent(percent);
        this.lastPercent = percent;
        if (this.mHeader.mPagerSlidingTabStrip != null && (newY = this.mHeader.mPagerSlidingTabStrip.getY() + scrollTop) >= this.mHeader.finalTabsY) {
            this.mHeader.mPagerSlidingTabStrip.setTranslationY(scrollTop);
            this.mHeader.toolbarLayoutBackground.setTranslationY(scrollTop);
        }
        if (this.mHeader.mLogo != null) {
            if (this.settings.hideLogoWithFade) {
                this.mHeader.mLogo.setAlpha(1.0f - percent);
                this.mHeader.mLogo.setTranslationY((this.mHeader.finalTitleY - this.mHeader.originalTitleY) * percent);
            } else {
                this.mHeader.mLogo.setTranslationY((this.mHeader.finalTitleY - this.mHeader.originalTitleY) * percent);
                this.mHeader.mLogo.setTranslationX((this.mHeader.finalTitleX - this.mHeader.originalTitleX) * percent);
                float scale = (1.0f - percent) * (1.0f - this.mHeader.finalScale) + this.mHeader.finalScale;
                MaterialViewPagerAnimator.setScale(scale, this.mHeader.mLogo);
            }
        }
        if (this.settings.hideToolbarAndTitle && this.mHeader.toolbarLayout != null) {
            boolean scrollUp;
            boolean bl = scrollUp = this.lastYOffset < yOffset;
            if (scrollUp) {
                this.followScrollToolbarLayout(yOffset);
            } else if (yOffset > (float)this.mHeader.toolbarLayout.getHeight()) {
                this.animateEnterToolbarLayout(yOffset);
            } else if (yOffset <= (float)this.mHeader.toolbarLayout.getHeight()) {
                if (this.headerAnimator != null) {
                    this.mHeader.toolbarLayout.setTranslationY(0.0f);
                } else {
                    this.headerYOffset = Float.MAX_VALUE;
                    this.followScrollToolbarLayout(yOffset);
                }
            }
        }
        if (this.headerAnimator != null && percent < 1.0f) {
            this.headerAnimator.cancel();
            this.headerAnimator = null;
        }
        this.lastYOffset = yOffset;
    }

    public void setColor(int color2, int duration) {
        ObjectAnimator colorAnim = ObjectAnimator.ofInt((Object)this.mHeader.headerBackground, (String)"backgroundColor", (int[])new int[]{this.settings.color, color2});
        colorAnim.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        colorAnim.setDuration((long)duration);
        colorAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int colorAlpha = Utils.colorWithAlpha((Integer)animation.getAnimatedValue(), MaterialViewPagerAnimator.this.lastPercent);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.statusBackground.setBackgroundColor(colorAlpha);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.toolbar.setBackgroundColor(colorAlpha);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.toolbarLayoutBackground.setBackgroundColor(colorAlpha);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.mPagerSlidingTabStrip.setBackgroundColor(colorAlpha);
            }
        });
        colorAnim.start();
        this.settings.color = color2;
    }

    public void setColorPercent(float percent) {
        MaterialViewPagerAnimator.setBackgroundColor(Utils.colorWithAlpha(this.settings.color, percent), this.mHeader.statusBackground);
        if (percent >= 1.0f) {
            MaterialViewPagerAnimator.setBackgroundColor(Utils.colorWithAlpha(this.settings.color, percent), new View[]{this.mHeader.toolbar, this.mHeader.toolbarLayoutBackground, this.mHeader.mPagerSlidingTabStrip});
        } else {
            MaterialViewPagerAnimator.setBackgroundColor(Utils.colorWithAlpha(this.settings.color, 0.0f), new View[]{this.mHeader.toolbar, this.mHeader.toolbarLayoutBackground, this.mHeader.mPagerSlidingTabStrip});
        }
        if (this.settings.enableToolbarElevation) {
            MaterialViewPagerAnimator.setElevation(percent == 1.0f ? this.elevation : 0.0f, new View[]{this.mHeader.toolbar, this.mHeader.toolbarLayoutBackground, this.mHeader.mPagerSlidingTabStrip, this.mHeader.mLogo});
        }
    }

    private void followScrollToolbarLayout(float yOffset) {
        float diffOffsetScrollMax;
        if (this.headerYOffset == Float.MAX_VALUE) {
            this.headerYOffset = this.scrollMax;
        }
        if ((diffOffsetScrollMax = this.headerYOffset - yOffset) <= 0.0f) {
            this.mHeader.toolbarLayout.setTranslationY(diffOffsetScrollMax);
        }
    }

    private void animateEnterToolbarLayout(float yOffset) {
        if (this.headerAnimator == null) {
            this.headerAnimator = ObjectAnimator.ofFloat((Object)this.mHeader.toolbarLayout, (String)"translationY", (float[])new float[]{0.0f}).setDuration(600L);
            this.headerAnimator.start();
            this.headerYOffset = yOffset;
        }
    }

    private static void setElevation(float elevation, View ... views) {
        for (View view : views) {
            if (view == null) continue;
            ViewCompat.setElevation((View)view, (float)elevation);
        }
    }

    private static void setBackgroundColor(int color2, View ... views) {
        for (View view : views) {
            if (view == null) continue;
            view.setBackgroundColor(color2);
        }
    }

    private static void setScale(float scale, View ... views) {
        for (View view : views) {
            if (view == null) continue;
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private static float minMax(float min, float value, float max) {
        value = Math.min(value, max);
        value = Math.max(min, value);
        return value;
    }

    public void registerRecyclerView(RecyclerView recyclerView, final RecyclerView.OnScrollListener onScrollListener) {
        if (recyclerView != null) {
            this.scrollViewList.add(recyclerView);
            this.yOffsets.put(recyclerView, 0);
            recyclerView.setOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                    super.onScrollStateChanged(recyclerView, newState);
                    if (onScrollListener != null) {
                        onScrollListener.onScrollStateChanged(recyclerView, newState);
                    }
                }

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    if (onScrollListener != null) {
                        onScrollListener.onScrolled(recyclerView, dx, dy);
                    }
                    int scrollY = (Integer)MaterialViewPagerAnimator.this.yOffsets.get(recyclerView);
                    if (MaterialViewPagerAnimator.this.calledScrollList.contains(recyclerView)) {
                        MaterialViewPagerAnimator.this.calledScrollList.remove(recyclerView);
                        return;
                    }
                    MaterialViewPagerAnimator.this.yOffsets.put(recyclerView, scrollY += dy);
                    MaterialViewPagerAnimator.this.onMaterialScrolled(recyclerView, scrollY);
                }
            });
        }
    }

    public void registerScrollView(final ObservableScrollView scrollView, final ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        if (scrollView != null) {
            this.scrollViewList.add(scrollView);
            scrollView.setScrollViewCallbacks(new ObservableScrollViewCallbacks(){

                public void onScrollChanged(int i, boolean b, boolean b2) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onScrollChanged(i, b, b2);
                    }
                    if (MaterialViewPagerAnimator.this.calledScrollList.contains(scrollView)) {
                        MaterialViewPagerAnimator.this.calledScrollList.remove(scrollView);
                        return;
                    }
                    MaterialViewPagerAnimator.this.onMaterialScrolled(scrollView, i);
                }

                public void onDownMotionEvent() {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onDownMotionEvent();
                    }
                }

                public void onUpOrCancelMotionEvent(ScrollState scrollState) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onUpOrCancelMotionEvent(scrollState);
                    }
                }
            });
        }
    }

    public void registerWebView(final ObservableWebView webView, final ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        if (webView != null) {
            this.scrollViewList.add(webView);
            webView.setScrollViewCallbacks(new ObservableScrollViewCallbacks(){

                public void onScrollChanged(int i, boolean b, boolean b2) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onScrollChanged(i, b, b2);
                    }
                    if (MaterialViewPagerAnimator.this.calledScrollList.contains(webView)) {
                        MaterialViewPagerAnimator.this.calledScrollList.remove(webView);
                        return;
                    }
                    MaterialViewPagerAnimator.this.onMaterialScrolled(webView, i);
                }

                public void onDownMotionEvent() {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onDownMotionEvent();
                    }
                }

                public void onUpOrCancelMotionEvent(ScrollState scrollState) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onUpOrCancelMotionEvent(scrollState);
                    }
                }
            });
        }
    }

    public int getHeaderHeight() {
        return this.settings.headerHeight;
    }

    @Deprecated
    public void registerListView(final ObservableListView listView, final ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        if (listView != null) {
            this.scrollViewList.add(listView);
            listView.setScrollViewCallbacks(new ObservableScrollViewCallbacks(){

                public void onScrollChanged(int i, boolean b, boolean b2) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onScrollChanged(i, b, b2);
                    }
                    if (MaterialViewPagerAnimator.this.calledScrollList.contains(listView)) {
                        MaterialViewPagerAnimator.this.calledScrollList.remove(listView);
                        return;
                    }
                    MaterialViewPagerAnimator.this.onMaterialScrolled(listView, i);
                }

                public void onDownMotionEvent() {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onDownMotionEvent();
                    }
                }

                public void onUpOrCancelMotionEvent(ScrollState scrollState) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onUpOrCancelMotionEvent(scrollState);
                    }
                }
            });
        }
    }
}

