/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.content.Context;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewTreeObserver;
import com.github.florent37.materialviewpager.Utils;

public class MaterialViewPagerHeader {
    protected Context context;
    protected View toolbarLayout;
    protected Toolbar toolbar;
    protected View mPagerSlidingTabStrip;
    protected View toolbarLayoutBackground;
    protected View headerBackground;
    protected View statusBackground;
    protected View mLogo;
    public float finalTabsY;
    public float finalTitleY;
    public float finalTitleHeight;
    public float finalTitleX;
    public float originalTitleY;
    public float originalTitleHeight;
    public float originalTitleX;
    public float finalScale;

    private MaterialViewPagerHeader(Toolbar toolbar) {
        this.toolbar = toolbar;
        this.context = toolbar.getContext();
        this.toolbarLayout = (View)toolbar.getParent();
    }

    public static MaterialViewPagerHeader withToolbar(Toolbar toolbar) {
        return new MaterialViewPagerHeader(toolbar);
    }

    public Context getContext() {
        return this.context;
    }

    public MaterialViewPagerHeader withPagerSlidingTabStrip(View pagerSlidingTabStrip) {
        this.mPagerSlidingTabStrip = pagerSlidingTabStrip;
        this.mPagerSlidingTabStrip.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                MaterialViewPagerHeader.this.finalTabsY = Utils.dpToPx(-2.0f, MaterialViewPagerHeader.this.context);
                MaterialViewPagerHeader.this.mPagerSlidingTabStrip.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                return false;
            }
        });
        return this;
    }

    public MaterialViewPagerHeader withHeaderBackground(View headerBackground) {
        this.headerBackground = headerBackground;
        return this;
    }

    public MaterialViewPagerHeader withStatusBackground(View statusBackground) {
        this.statusBackground = statusBackground;
        return this;
    }

    public MaterialViewPagerHeader withToolbarLayoutBackground(View toolbarLayoutBackground) {
        this.toolbarLayoutBackground = toolbarLayoutBackground;
        return this;
    }

    public MaterialViewPagerHeader withLogo(View logo) {
        this.mLogo = logo;
        this.mLogo.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                MaterialViewPagerHeader.this.finalTitleY = Utils.dpToPx(34.0f, MaterialViewPagerHeader.this.context);
                MaterialViewPagerHeader.this.originalTitleY = MaterialViewPagerHeader.this.mLogo.getY();
                MaterialViewPagerHeader.this.originalTitleX = MaterialViewPagerHeader.this.mLogo.getX();
                MaterialViewPagerHeader.this.originalTitleHeight = MaterialViewPagerHeader.this.mLogo.getHeight();
                MaterialViewPagerHeader.this.finalTitleHeight = Utils.dpToPx(21.0f, MaterialViewPagerHeader.this.context);
                MaterialViewPagerHeader.this.finalScale = MaterialViewPagerHeader.this.finalTitleHeight / MaterialViewPagerHeader.this.originalTitleHeight;
                MaterialViewPagerHeader.this.finalTitleX = Utils.dpToPx(52.0f, MaterialViewPagerHeader.this.context) - (float)(MaterialViewPagerHeader.this.mLogo.getWidth() / 2) * (1.0f - MaterialViewPagerHeader.this.finalScale);
                MaterialViewPagerHeader.this.mLogo.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                return false;
            }
        });
        return this;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public View getHeaderBackground() {
        return this.headerBackground;
    }

    public View getStatusBackground() {
        return this.statusBackground;
    }

    public View getLogo() {
        return this.mLogo;
    }
}

