/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.github.florent37.materialviewpager.MaterialViewPagerAnimator;
import com.github.ksoichiro.android.observablescrollview.ObservableListView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollViewCallbacks;
import com.github.ksoichiro.android.observablescrollview.ObservableWebView;
import java.util.concurrent.ConcurrentHashMap;

public class MaterialViewPagerHelper {
    private static ConcurrentHashMap<Object, MaterialViewPagerAnimator> hashMap = new ConcurrentHashMap();

    public static void register(Activity activity, MaterialViewPagerAnimator animator) {
        if (!hashMap.containsKey(activity)) {
            hashMap.put(activity, animator);
        }
    }

    public static void registerRecyclerView(Activity activity, RecyclerView recyclerView, RecyclerView.OnScrollListener onScrollListener) {
        MaterialViewPagerAnimator animator;
        if (activity != null && hashMap.containsKey(activity) && (animator = hashMap.get(activity)) != null) {
            animator.registerRecyclerView(recyclerView, onScrollListener);
        }
    }

    public static void registerWebView(Activity activity, ObservableWebView webView, ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        MaterialViewPagerAnimator animator;
        if (activity != null && hashMap.containsKey(activity) && (animator = hashMap.get(activity)) != null) {
            animator.registerWebView(webView, observableScrollViewCallbacks);
        }
    }

    @Deprecated
    public static void registerListView(Activity activity, ObservableListView listView, ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        MaterialViewPagerAnimator animator;
        if (activity != null && hashMap.containsKey(activity) && (animator = hashMap.get(activity)) != null) {
            animator.registerListView(listView, observableScrollViewCallbacks);
        }
    }

    public static void registerScrollView(Activity activity, ObservableScrollView mScrollView, ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        MaterialViewPagerAnimator animator;
        if (activity != null && hashMap.containsKey(activity) && (animator = hashMap.get(activity)) != null) {
            animator.registerScrollView(mScrollView, observableScrollViewCallbacks);
        }
    }

    public static MaterialViewPagerAnimator getAnimator(Context context) {
        return hashMap.get(context);
    }

    public static void injectHeader(final WebView webView, boolean withAnimation) {
        MaterialViewPagerAnimator animator;
        if (webView != null && (animator = MaterialViewPagerHelper.getAnimator(webView.getContext())) != null) {
            WebSettings webSettings = webView.getSettings();
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
            webSettings.setCacheMode(2);
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webView.setLayerType(1, null);
            int marginTop = animator.getHeaderHeight() + 10;
            String js = String.format("document.body.style.marginTop= \"%dpx\"", marginTop);
            webView.evaluateJavascript(js, null);
            String js2 = "document.body.style.backround-color= white";
            webView.evaluateJavascript("document.body.style.backround-color= white", null);
            if (withAnimation) {
                webView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        webView.setVisibility(0);
                        ObjectAnimator.ofFloat((Object)webView, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).start();
                    }
                }, 400L);
            }
        }
    }

    public static void preLoadInjectHeader(WebView mWebView) {
        mWebView.setBackgroundColor(0);
        mWebView.setVisibility(4);
    }
}

