/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.github.florent37.materialviewpager.R;
import com.github.florent37.materialviewpager.Utils;

public class MaterialViewPagerSettings {
    protected int headerLayoutId;
    protected int pagerTitleStripId;
    protected int logoLayoutId;
    protected int logoMarginTop;
    protected int headerHeight;
    protected int color;
    protected boolean hideToolbarAndTitle;
    protected boolean hideLogoWithFade;
    protected boolean enableToolbarElevation;

    protected void handleAttributes(Context context, AttributeSet attrs) {
        try {
            TypedArray styledAttrs = context.obtainStyledAttributes(attrs, R.styleable.MaterialViewPager);
            this.headerLayoutId = styledAttrs.getResourceId(R.styleable.MaterialViewPager_viewpager_header, -1);
            if (this.headerLayoutId == -1) {
                this.headerLayoutId = R.layout.material_view_pager_default_header;
            }
            this.pagerTitleStripId = styledAttrs.getResourceId(R.styleable.MaterialViewPager_viewpager_pagerTitleStrip, -1);
            if (this.pagerTitleStripId == -1) {
                this.pagerTitleStripId = R.layout.material_view_pager_pagertitlestrip_standard;
            }
            this.logoLayoutId = styledAttrs.getResourceId(R.styleable.MaterialViewPager_viewpager_logo, -1);
            this.logoMarginTop = styledAttrs.getDimensionPixelSize(R.styleable.MaterialViewPager_viewpager_logoMarginTop, 0);
            this.color = styledAttrs.getColor(R.styleable.MaterialViewPager_viewpager_color, 0);
            this.headerHeight = styledAttrs.getDimensionPixelOffset(R.styleable.MaterialViewPager_viewpager_headerHeight, 200);
            this.headerHeight = Math.round(Utils.pxToDp(this.headerHeight, context));
            this.hideToolbarAndTitle = styledAttrs.getBoolean(R.styleable.MaterialViewPager_viewpager_hideToolbarAndTitle, false);
            this.hideLogoWithFade = styledAttrs.getBoolean(R.styleable.MaterialViewPager_viewpager_hideLogoWithFade, false);
            this.enableToolbarElevation = styledAttrs.getBoolean(R.styleable.MaterialViewPager_viewpager_enableToolbarElevation, false);
            styledAttrs.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

