/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.astuetz.PagerSlidingTabStrip;
import com.github.florent37.materialviewpager.HeaderDesign;
import com.github.florent37.materialviewpager.MaterialViewPagerAnimator;
import com.github.florent37.materialviewpager.MaterialViewPagerHeader;
import com.github.florent37.materialviewpager.MaterialViewPagerHelper;
import com.github.florent37.materialviewpager.MaterialViewPagerImageHeader;
import com.github.florent37.materialviewpager.MaterialViewPagerSettings;
import com.github.florent37.materialviewpager.R;
import com.github.florent37.materialviewpager.Utils;
import com.nineoldandroids.view.ViewHelper;

public class MaterialViewPager
extends FrameLayout
implements ViewPager.OnPageChangeListener {
    private ViewGroup headerBackgroundContainer;
    private ViewGroup pagerTitleStripContainer;
    private ViewGroup logoContainer;
    protected MaterialViewPagerHeader materialViewPagerHeader;
    protected Toolbar mToolbar;
    protected ViewPager mViewPager;
    protected View headerBackground;
    protected View toolbarLayoutBackground;
    protected MaterialViewPagerSettings settings = new MaterialViewPagerSettings();
    protected MaterialViewPagerListener listener;
    int lastPosition = 0;

    public MaterialViewPager(Context context) {
        super(context);
    }

    public MaterialViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.settings.handleAttributes(context, attrs);
    }

    public MaterialViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.settings.handleAttributes(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.settings.handleAttributes(context, attrs);
    }

    protected void onDetachedFromWindow() {
        MaterialViewPagerHelper.unregister(this.getContext());
        this.listener = null;
        super.onDetachedFromWindow();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.material_view_pager_layout, (ViewGroup)this, false));
        this.headerBackgroundContainer = (ViewGroup)this.findViewById(R.id.headerBackgroundContainer);
        this.pagerTitleStripContainer = (ViewGroup)this.findViewById(R.id.pagerTitleStripContainer);
        this.logoContainer = (ViewGroup)this.findViewById(R.id.logoContainer);
        this.mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.mViewPager = (ViewPager)this.findViewById(R.id.viewPager);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        if (this.settings.headerLayoutId != -1) {
            this.headerBackgroundContainer.addView(LayoutInflater.from((Context)this.getContext()).inflate(this.settings.headerLayoutId, this.headerBackgroundContainer, false));
        }
        if (this.isInEditMode()) {
            this.settings.pagerTitleStripId = R.layout.tools_material_view_pager_pagertitlestrip;
        }
        if (this.settings.pagerTitleStripId != -1) {
            this.pagerTitleStripContainer.addView(LayoutInflater.from((Context)this.getContext()).inflate(this.settings.pagerTitleStripId, this.pagerTitleStripContainer, false));
        }
        if (this.settings.logoLayoutId != -1) {
            this.logoContainer.addView(LayoutInflater.from((Context)this.getContext()).inflate(this.settings.logoLayoutId, this.logoContainer, false));
            if (this.settings.logoMarginTop != 0) {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.logoContainer.getLayoutParams();
                layoutParams.setMargins(0, this.settings.logoMarginTop, 0, 0);
                this.logoContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.headerBackground = this.findViewById(R.id.headerBackground);
        this.toolbarLayoutBackground = this.findViewById(R.id.toolbar_layout_background);
        this.initialiseHeights();
        if (!this.isInEditMode()) {
            this.materialViewPagerHeader = MaterialViewPagerHeader.withToolbar(this.mToolbar).withToolbarLayoutBackground(this.toolbarLayoutBackground).withPagerSlidingTabStrip((View)this.pagerTitleStripContainer).withHeaderBackground(this.headerBackground).withStatusBackground(this.findViewById(R.id.statusBackground)).withLogo((View)this.logoContainer);
            MaterialViewPagerHelper.register(this.getContext(), new MaterialViewPagerAnimator(this));
        } else {
            View sample = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tools_list_items, this.pagerTitleStripContainer, false);
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)sample.getLayoutParams();
            int marginTop = Math.round(Utils.dpToPx(this.settings.headerHeight + 10, this.getContext()));
            params.setMargins(0, marginTop, 0, 0);
            super.setLayoutParams((ViewGroup.LayoutParams)params);
            this.addView(sample);
        }
    }

    private void initialiseHeights() {
        RelativeLayout.LayoutParams layoutParams;
        if (this.headerBackground != null) {
            this.headerBackground.setBackgroundColor(this.settings.color);
            layoutParams = this.headerBackground.getLayoutParams();
            layoutParams.height = (int)Utils.dpToPx(this.settings.headerHeight + this.settings.headerAdditionalHeight, this.getContext());
            this.headerBackground.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (this.pagerTitleStripContainer != null) {
            layoutParams = (RelativeLayout.LayoutParams)this.pagerTitleStripContainer.getLayoutParams();
            int marginTop = (int)Utils.dpToPx(this.settings.headerHeight - 40, this.getContext());
            layoutParams.setMargins(0, marginTop, 0, 0);
            this.pagerTitleStripContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (this.toolbarLayoutBackground != null) {
            layoutParams = this.toolbarLayoutBackground.getLayoutParams();
            layoutParams.height = (int)Utils.dpToPx(this.settings.headerHeight, this.getContext());
            this.toolbarLayoutBackground.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public PagerSlidingTabStrip getPagerTitleStrip() {
        return (PagerSlidingTabStrip)this.pagerTitleStripContainer.findViewById(R.id.materialviewpager_pagerTitleStrip);
    }

    public Toolbar getToolbar() {
        return this.mToolbar;
    }

    public void setImageUrl(String imageUrl, int fadeDuration) {
        MaterialViewPagerImageHeader headerBackgroundImage;
        if (imageUrl != null && (headerBackgroundImage = (MaterialViewPagerImageHeader)this.findViewById(R.id.materialviewpager_imageHeader)) != null) {
            ViewHelper.setAlpha((View)headerBackgroundImage, (float)this.settings.headerAlpha);
            headerBackgroundImage.setImageUrl(imageUrl, fadeDuration);
        }
    }

    public void setImageDrawable(Drawable drawable2, int fadeDuration) {
        MaterialViewPagerImageHeader headerBackgroundImage;
        if (drawable2 != null && (headerBackgroundImage = (MaterialViewPagerImageHeader)this.findViewById(R.id.materialviewpager_imageHeader)) != null) {
            ViewHelper.setAlpha((View)headerBackgroundImage, (float)this.settings.headerAlpha);
            headerBackgroundImage.setImageDrawable(drawable2, fadeDuration);
        }
    }

    public void setColor(int color2, int fadeDuration) {
        MaterialViewPagerHelper.getAnimator(this.getContext()).setColor(color2, fadeDuration * 2);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.settings = this.settings;
        ss.yOffset = MaterialViewPagerHelper.getAnimator((Context)this.getContext()).lastYOffset;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.settings = ss.settings;
        if (this.headerBackground != null) {
            this.headerBackground.setBackgroundColor(this.settings.color);
        }
        MaterialViewPagerAnimator animator = MaterialViewPagerHelper.getAnimator(this.getContext());
        animator.restoreScroll(-1.0f * ss.yOffset, ss.settings);
        MaterialViewPagerHelper.register(this.getContext(), animator);
    }

    public ViewGroup getHeaderBackgroundContainer() {
        return this.headerBackgroundContainer;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if ((double)positionOffset >= 0.5) {
            this.onPageSelected(position + 1);
        } else if ((double)positionOffset <= -0.5) {
            this.onPageSelected(position - 1);
        } else {
            this.onPageSelected(position);
        }
    }

    public void onPageSelected(int position) {
        if (position == this.lastPosition || this.listener == null) {
            return;
        }
        HeaderDesign headerDesign = this.listener.getHeaderDesign(position);
        if (headerDesign == null) {
            return;
        }
        int fadeDuration = 400;
        int color2 = headerDesign.getColor();
        if (headerDesign.getColorRes() != 0) {
            color2 = this.getContext().getResources().getColor(headerDesign.getColorRes());
        }
        if (headerDesign.getDrawable() != null) {
            this.setImageDrawable(headerDesign.getDrawable(), fadeDuration);
        } else {
            this.setImageUrl(headerDesign.getImageUrl(), fadeDuration);
        }
        this.setColor(color2, fadeDuration);
        this.lastPosition = position;
    }

    public void onPageScrollStateChanged(int state) {
        if (this.settings.displayToolbarWhenSwipe) {
            MaterialViewPagerHelper.getAnimator(this.getContext()).onViewPagerPageChanged();
        }
    }

    public void setMaterialViewPagerListener(MaterialViewPagerListener listener) {
        this.listener = listener;
    }

    public static interface MaterialViewPagerListener {
        public HeaderDesign getHeaderDesign(int var1);
    }

    static class SavedState
    extends View.BaseSavedState {
        public MaterialViewPagerSettings settings;
        public float yOffset;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.settings = (MaterialViewPagerSettings)in.readParcelable(MaterialViewPagerSettings.class.getClassLoader());
            this.yOffset = in.readFloat();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeParcelable((Parcelable)this.settings, flags);
            out.writeFloat(this.yOffset);
        }
    }
}

