/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Build;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ListView;
import android.widget.ScrollView;
import com.github.florent37.materialviewpager.MaterialViewPager;
import com.github.florent37.materialviewpager.MaterialViewPagerHeader;
import com.github.florent37.materialviewpager.MaterialViewPagerSettings;
import com.github.florent37.materialviewpager.Utils;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollViewCallbacks;
import com.github.ksoichiro.android.observablescrollview.ObservableWebView;
import com.github.ksoichiro.android.observablescrollview.ScrollState;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ArgbEvaluator;
import com.nineoldandroids.animation.TypeEvaluator;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MaterialViewPagerAnimator {
    private static final String TAG = MaterialViewPagerAnimator.class.getSimpleName();
    private static final Boolean ENABLE_LOG = false;
    private Context context;
    private MaterialViewPagerHeader mHeader;
    private static final int ENTER_TOOLBAR_ANIMATION_DURATION = 600;
    protected MaterialViewPager materialViewPager;
    public final float elevation;
    public final float scrollMax;
    public final float scrollMaxDp;
    protected float lastYOffset = -1.0f;
    protected float lastPercent = 0.0f;
    protected MaterialViewPagerSettings settings;
    protected List<Object> scrollViewList = new ArrayList<Object>();
    protected HashMap<Object, Integer> yOffsets = new HashMap();
    private float headerYOffset = Float.MAX_VALUE;
    private Object headerAnimator;
    boolean followScrollToolbarIsVisible = false;
    float firstScrollValue = Float.MIN_VALUE;

    public MaterialViewPagerAnimator(MaterialViewPager materialViewPager) {
        this.settings = materialViewPager.settings;
        this.materialViewPager = materialViewPager;
        this.mHeader = materialViewPager.materialViewPagerHeader;
        this.context = this.mHeader.getContext();
        this.scrollMax = this.settings.headerHeight;
        this.scrollMaxDp = Utils.dpToPx(this.scrollMax, this.context);
        this.elevation = Utils.dpToPx(4.0f, this.context);
    }

    private void dispatchScrollOffset(Object source, float yOffset) {
        if (this.scrollViewList != null) {
            for (Object scroll : this.scrollViewList) {
                if (scroll == null || scroll == source) continue;
                this.setScrollOffset(scroll, yOffset);
            }
        }
    }

    private void setScrollOffset(Object scroll, float yOffset) {
        if (scroll != null && yOffset >= 0.0f) {
            if (scroll instanceof RecyclerView) {
                RecyclerView.LayoutManager layoutManager = ((RecyclerView)scroll).getLayoutManager();
                if (layoutManager instanceof LinearLayoutManager) {
                    LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
                    linearLayoutManager.scrollToPositionWithOffset(0, (int)(-yOffset));
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                    staggeredGridLayoutManager.scrollToPositionWithOffset(0, (int)(-yOffset));
                }
            } else if (scroll instanceof ScrollView) {
                ((ScrollView)scroll).scrollTo(0, (int)yOffset);
            } else if (scroll instanceof ListView) {
                ((ListView)scroll).scrollTo(0, (int)yOffset);
            } else if (scroll instanceof WebView) {
                ((WebView)scroll).scrollTo(0, (int)yOffset);
            }
            this.yOffsets.put(scroll, (int)yOffset);
        }
    }

    public void onMaterialScrolled(Object source, float yOffset) {
        if (yOffset == this.lastYOffset) {
            return;
        }
        float scrollTop = -yOffset;
        if (this.mHeader.headerBackground != null) {
            if (this.settings.parallaxHeaderFactor != 0.0f) {
                ViewHelper.setTranslationY((View)this.mHeader.headerBackground, (float)(scrollTop / this.settings.parallaxHeaderFactor));
            }
            if (ViewHelper.getY((View)this.mHeader.headerBackground) >= 0.0f) {
                ViewHelper.setY((View)this.mHeader.headerBackground, (float)0.0f);
            }
        }
        if (ENABLE_LOG.booleanValue()) {
            Log.d((String)"yOffset", (String)("" + yOffset));
        }
        this.dispatchScrollOffset(source, Utils.minMax(0.0f, yOffset, this.scrollMaxDp));
        float percent = yOffset / this.scrollMax;
        percent = Utils.minMax(0.0f, percent, 1.0f);
        this.setColorPercent(percent);
        this.lastPercent = percent;
        if (this.mHeader.mPagerSlidingTabStrip != null) {
            if (ENABLE_LOG.booleanValue()) {
                Log.d((String)TAG, (String)("" + scrollTop));
            }
            if (scrollTop <= 0.0f) {
                ViewHelper.setTranslationY((View)this.mHeader.mPagerSlidingTabStrip, (float)scrollTop);
                ViewHelper.setTranslationY((View)this.mHeader.toolbarLayoutBackground, (float)scrollTop);
                if (ViewHelper.getY((View)this.mHeader.mPagerSlidingTabStrip) < (float)this.mHeader.getToolbar().getBottom()) {
                    float ty = this.mHeader.getToolbar().getBottom() - this.mHeader.mPagerSlidingTabStrip.getTop();
                    ViewHelper.setTranslationY((View)this.mHeader.mPagerSlidingTabStrip, (float)ty);
                    ViewHelper.setTranslationY((View)this.mHeader.toolbarLayoutBackground, (float)ty);
                }
            }
        }
        if (this.mHeader.mLogo != null) {
            if (this.settings.hideLogoWithFade) {
                ViewHelper.setAlpha((View)this.mHeader.mLogo, (float)(1.0f - percent));
                ViewHelper.setTranslationY((View)this.mHeader.mLogo, (float)((this.mHeader.finalTitleY - this.mHeader.originalTitleY) * percent));
            } else {
                ViewHelper.setTranslationY((View)this.mHeader.mLogo, (float)((this.mHeader.finalTitleY - this.mHeader.originalTitleY) * percent));
                ViewHelper.setTranslationX((View)this.mHeader.mLogo, (float)((this.mHeader.finalTitleX - this.mHeader.originalTitleX) * percent));
                float scale = (1.0f - percent) * (1.0f - this.mHeader.finalScale) + this.mHeader.finalScale;
                Utils.setScale(scale, this.mHeader.mLogo);
            }
        }
        if (this.settings.hideToolbarAndTitle && this.mHeader.toolbarLayout != null) {
            boolean scrollUp;
            boolean bl = scrollUp = this.lastYOffset < yOffset;
            if (scrollUp) {
                this.scrollUp(yOffset);
            } else {
                this.scrollDown(yOffset);
            }
        }
        if (this.headerAnimator != null && percent < 1.0f) {
            if (this.headerAnimator instanceof com.nineoldandroids.animation.ObjectAnimator) {
                ((com.nineoldandroids.animation.ObjectAnimator)this.headerAnimator).cancel();
            } else if (this.headerAnimator instanceof ObjectAnimator) {
                ((ObjectAnimator)this.headerAnimator).cancel();
            }
            this.headerAnimator = null;
        }
        this.lastYOffset = yOffset;
    }

    private void scrollUp(float yOffset) {
        if (ENABLE_LOG.booleanValue()) {
            Log.d((String)TAG, (String)"scrollUp");
        }
        this.followScrollToolbarLayout(yOffset);
    }

    private void scrollDown(float yOffset) {
        if (ENABLE_LOG.booleanValue()) {
            Log.d((String)TAG, (String)"scrollDown");
        }
        if (yOffset > (float)this.mHeader.toolbarLayout.getHeight()) {
            this.animateEnterToolbarLayout(yOffset);
        } else if (this.headerAnimator != null) {
            ViewHelper.setTranslationY((View)this.mHeader.toolbarLayout, (float)0.0f);
            this.followScrollToolbarIsVisible = true;
        } else {
            this.headerYOffset = Float.MAX_VALUE;
            this.followScrollToolbarLayout(yOffset);
        }
    }

    public void setColor(int color2, int duration) {
        com.nineoldandroids.animation.ObjectAnimator colorAnim = com.nineoldandroids.animation.ObjectAnimator.ofInt((Object)this.mHeader.headerBackground, (String)"backgroundColor", (int[])new int[]{this.settings.color, color2});
        colorAnim.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        colorAnim.setDuration((long)duration);
        colorAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int colorAlpha = Utils.colorWithAlpha((Integer)animation.getAnimatedValue(), MaterialViewPagerAnimator.this.lastPercent);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.headerBackground.setBackgroundColor(colorAlpha);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.statusBackground.setBackgroundColor(colorAlpha);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.toolbar.setBackgroundColor(colorAlpha);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.toolbarLayoutBackground.setBackgroundColor(colorAlpha);
                ((MaterialViewPagerAnimator)MaterialViewPagerAnimator.this).mHeader.mPagerSlidingTabStrip.setBackgroundColor(colorAlpha);
            }
        });
        colorAnim.start();
        this.settings.color = color2;
    }

    public void setColorPercent(float percent) {
        Utils.setBackgroundColor(Utils.colorWithAlpha(this.settings.color, percent), this.mHeader.statusBackground);
        if (percent >= 1.0f) {
            Utils.setBackgroundColor(Utils.colorWithAlpha(this.settings.color, percent), new View[]{this.mHeader.toolbar, this.mHeader.toolbarLayoutBackground, this.mHeader.mPagerSlidingTabStrip});
        } else {
            Utils.setBackgroundColor(Utils.colorWithAlpha(this.settings.color, 0.0f), new View[]{this.mHeader.toolbar, this.mHeader.toolbarLayoutBackground, this.mHeader.mPagerSlidingTabStrip});
        }
        if (this.settings.enableToolbarElevation && this.toolbarJoinsTabs()) {
            Utils.setElevation(percent == 1.0f ? this.elevation : 0.0f, new View[]{this.mHeader.toolbar, this.mHeader.toolbarLayoutBackground, this.mHeader.mPagerSlidingTabStrip, this.mHeader.mLogo});
        }
    }

    private boolean toolbarJoinsTabs() {
        return (float)this.mHeader.toolbar.getBottom() == (float)this.mHeader.mPagerSlidingTabStrip.getTop() + ViewHelper.getTranslationY((View)this.mHeader.mPagerSlidingTabStrip);
    }

    private void followScrollToolbarLayout(float yOffset) {
        if (this.mHeader.toolbar.getBottom() == 0) {
            return;
        }
        if (this.toolbarJoinsTabs()) {
            if (this.firstScrollValue == Float.MIN_VALUE) {
                this.firstScrollValue = yOffset;
            }
            ViewHelper.setTranslationY((View)this.mHeader.toolbarLayout, (float)(this.firstScrollValue - yOffset));
        } else {
            ViewHelper.setTranslationY((View)this.mHeader.toolbarLayout, (float)0.0f);
        }
        this.followScrollToolbarIsVisible = ViewHelper.getY((View)this.mHeader.toolbarLayout) >= 0.0f;
    }

    private void animateEnterToolbarLayout(float yOffset) {
        if (!this.followScrollToolbarIsVisible && this.headerAnimator != null) {
            if (this.headerAnimator instanceof com.nineoldandroids.animation.ObjectAnimator) {
                ((com.nineoldandroids.animation.ObjectAnimator)this.headerAnimator).cancel();
            } else if (this.headerAnimator instanceof ObjectAnimator) {
                ((ObjectAnimator)this.headerAnimator).cancel();
            }
            this.headerAnimator = null;
        }
        if (this.headerAnimator == null) {
            if (Build.VERSION.SDK_INT > 10) {
                this.headerAnimator = ObjectAnimator.ofFloat((Object)this.mHeader.toolbarLayout, (String)"translationY", (float[])new float[]{0.0f}).setDuration(600L);
                ((ObjectAnimator)this.headerAnimator).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(android.animation.Animator animation) {
                        super.onAnimationEnd(animation);
                        MaterialViewPagerAnimator.this.followScrollToolbarIsVisible = true;
                    }
                });
                ((ObjectAnimator)this.headerAnimator).start();
            } else {
                this.headerAnimator = com.nineoldandroids.animation.ObjectAnimator.ofFloat((Object)this.mHeader.toolbarLayout, (String)"translationY", (float[])new float[]{0.0f}).setDuration(600L);
                ((com.nineoldandroids.animation.ObjectAnimator)this.headerAnimator).addListener((Animator.AnimatorListener)new com.nineoldandroids.animation.AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        MaterialViewPagerAnimator.this.followScrollToolbarIsVisible = true;
                    }
                });
                ((com.nineoldandroids.animation.ObjectAnimator)this.headerAnimator).start();
            }
            this.headerYOffset = yOffset;
        }
    }

    public int getHeaderHeight() {
        return this.settings.headerHeight;
    }

    protected boolean isNewYOffset(int yOffset) {
        if (this.lastYOffset == -1.0f) {
            return true;
        }
        return (float)yOffset != this.lastYOffset;
    }

    public void registerRecyclerView(final RecyclerView recyclerView, final RecyclerView.OnScrollListener onScrollListener) {
        if (recyclerView != null) {
            this.scrollViewList.add(recyclerView);
            this.yOffsets.put(recyclerView, recyclerView.getScrollY());
            recyclerView.setOnScrollListener(new RecyclerView.OnScrollListener(){
                boolean firstZeroPassed;

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                    super.onScrollStateChanged(recyclerView, newState);
                    if (onScrollListener != null) {
                        onScrollListener.onScrollStateChanged(recyclerView, newState);
                    }
                }

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    if (onScrollListener != null) {
                        onScrollListener.onScrolled(recyclerView, dx, dy);
                    }
                    int yOffset = MaterialViewPagerAnimator.this.yOffsets.get(recyclerView);
                    MaterialViewPagerAnimator.this.yOffsets.put(recyclerView, yOffset += dy);
                    if (yOffset == 0 && !this.firstZeroPassed) {
                        this.firstZeroPassed = true;
                        return;
                    }
                    if (MaterialViewPagerAnimator.this.isNewYOffset(yOffset)) {
                        MaterialViewPagerAnimator.this.onMaterialScrolled(recyclerView, yOffset);
                    }
                }
            });
            recyclerView.post(new Runnable(){

                @Override
                public void run() {
                    MaterialViewPagerAnimator.this.setScrollOffset(recyclerView, MaterialViewPagerAnimator.this.lastYOffset);
                }
            });
        }
    }

    public void registerScrollView(final ObservableScrollView scrollView, final ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        if (scrollView != null) {
            this.scrollViewList.add(scrollView);
            if (scrollView.getParent() != null && scrollView.getParent().getParent() != null && scrollView.getParent().getParent() instanceof ViewGroup) {
                scrollView.setTouchInterceptionViewGroup((ViewGroup)scrollView.getParent().getParent());
            }
            scrollView.setScrollViewCallbacks(new ObservableScrollViewCallbacks(){
                boolean firstZeroPassed;

                public void onScrollChanged(int yOffset, boolean b, boolean b2) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onScrollChanged(yOffset, b, b2);
                    }
                    if (yOffset == 0 && !this.firstZeroPassed) {
                        this.firstZeroPassed = true;
                        return;
                    }
                    if (MaterialViewPagerAnimator.this.isNewYOffset(yOffset)) {
                        MaterialViewPagerAnimator.this.onMaterialScrolled(scrollView, yOffset);
                    }
                }

                public void onDownMotionEvent() {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onDownMotionEvent();
                    }
                }

                public void onUpOrCancelMotionEvent(ScrollState scrollState) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onUpOrCancelMotionEvent(scrollState);
                    }
                }
            });
            scrollView.post(new Runnable(){

                @Override
                public void run() {
                    MaterialViewPagerAnimator.this.setScrollOffset(scrollView, MaterialViewPagerAnimator.this.lastYOffset);
                }
            });
        }
    }

    public void registerWebView(final ObservableWebView webView, final ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        if (webView != null) {
            if (this.scrollViewList.isEmpty()) {
                this.onMaterialScrolled(webView, webView.getCurrentScrollY());
            }
            this.scrollViewList.add(webView);
            webView.setScrollViewCallbacks(new ObservableScrollViewCallbacks(){

                public void onScrollChanged(int yOffset, boolean b, boolean b2) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onScrollChanged(yOffset, b, b2);
                    }
                    if (MaterialViewPagerAnimator.this.isNewYOffset(yOffset)) {
                        MaterialViewPagerAnimator.this.onMaterialScrolled(webView, yOffset);
                    }
                }

                public void onDownMotionEvent() {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onDownMotionEvent();
                    }
                }

                public void onUpOrCancelMotionEvent(ScrollState scrollState) {
                    if (observableScrollViewCallbacks != null) {
                        observableScrollViewCallbacks.onUpOrCancelMotionEvent(scrollState);
                    }
                }
            });
            this.setScrollOffset(webView, -this.lastYOffset);
        }
    }

    public void restoreScroll(float scroll, MaterialViewPagerSettings settings) {
        this.settings = settings;
        this.onMaterialScrolled(null, scroll);
    }

    public void onViewPagerPageChanged() {
        this.scrollDown(this.lastYOffset);
    }
}

