/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.github.florent37.materialviewpager.MaterialViewPagerAnimator;
import com.github.florent37.materialviewpager.MaterialViewPagerHelper;
import com.github.florent37.materialviewpager.Utils;

public class MaterialViewPagerHeaderView
extends View {
    public MaterialViewPagerHeaderView(Context context) {
        super(context);
    }

    public MaterialViewPagerHeaderView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MaterialViewPagerHeaderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public MaterialViewPagerHeaderView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    private void setMaterialHeight() {
        MaterialViewPagerAnimator animator = MaterialViewPagerHelper.getAnimator(this.getContext());
        if (animator != null) {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            params.height = Math.round(Utils.dpToPx(animator.getHeaderHeight() + 10, this.getContext()));
            super.setLayoutParams(params);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (!this.isInEditMode()) {
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    MaterialViewPagerHeaderView.this.setMaterialHeight();
                    MaterialViewPagerHeaderView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return false;
                }
            });
        }
    }
}

