/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.github.florent37.materialviewpager.MaterialViewPagerAnimator;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollViewCallbacks;
import com.github.ksoichiro.android.observablescrollview.ObservableWebView;
import com.nineoldandroids.animation.ObjectAnimator;
import java.util.concurrent.ConcurrentHashMap;

public class MaterialViewPagerHelper {
    private static ConcurrentHashMap<Object, MaterialViewPagerAnimator> hashMap = new ConcurrentHashMap();

    public static void register(Context context, MaterialViewPagerAnimator animator) {
        hashMap.put(context, animator);
    }

    public static void unregister(Context context) {
        if (context != null) {
            hashMap.remove(context);
        }
    }

    public static void registerRecyclerView(Activity activity, RecyclerView recyclerView, RecyclerView.OnScrollListener onScrollListener) {
        MaterialViewPagerAnimator animator;
        if (activity != null && hashMap.containsKey(activity) && (animator = hashMap.get(activity)) != null) {
            animator.registerRecyclerView(recyclerView, onScrollListener);
        }
    }

    public static void registerWebView(Activity activity, ObservableWebView webView, ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        MaterialViewPagerAnimator animator;
        if (activity != null && hashMap.containsKey(activity) && (animator = hashMap.get(activity)) != null) {
            animator.registerWebView(webView, observableScrollViewCallbacks);
        }
    }

    public static void registerScrollView(Activity activity, ObservableScrollView mScrollView, ObservableScrollViewCallbacks observableScrollViewCallbacks) {
        MaterialViewPagerAnimator animator;
        if (activity != null && hashMap.containsKey(activity) && (animator = hashMap.get(activity)) != null) {
            animator.registerScrollView(mScrollView, observableScrollViewCallbacks);
        }
    }

    public static MaterialViewPagerAnimator getAnimator(Context context) {
        return hashMap.get(context);
    }

    private static void webViewLoadJS(WebView webView, String js) {
        if (Build.VERSION.SDK_INT >= 19) {
            webView.evaluateJavascript(js, null);
        } else {
            webView.loadUrl("javascript: " + js);
        }
    }

    public static void injectHeader(final WebView webView, boolean withAnimation) {
        MaterialViewPagerAnimator animator;
        if (webView != null && (animator = MaterialViewPagerHelper.getAnimator(webView.getContext())) != null) {
            WebSettings webSettings = webView.getSettings();
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
            webSettings.setCacheMode(2);
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
            if (Build.VERSION.SDK_INT >= 11) {
                webView.setLayerType(1, null);
            }
            int marginTop = animator.getHeaderHeight() + 10;
            String js = String.format("document.body.style.marginTop= \"%dpx\"", marginTop);
            MaterialViewPagerHelper.webViewLoadJS(webView, js);
            String js2 = "document.body.style.backround-color= white";
            MaterialViewPagerHelper.webViewLoadJS(webView, "document.body.style.backround-color= white");
            if (withAnimation) {
                webView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        webView.setVisibility(0);
                        ObjectAnimator.ofFloat((Object)webView, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).start();
                    }
                }, 400L);
            }
        }
    }

    public static void preLoadInjectHeader(WebView mWebView) {
        mWebView.setBackgroundColor(0);
        mWebView.setVisibility(4);
    }
}

