/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.materialviewpager;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.view.ViewCompat;
import android.view.View;
import com.nineoldandroids.view.ViewHelper;

public class Utils {
    public static float dpToPx(float dp, Context context) {
        return dp * context.getResources().getDisplayMetrics().density;
    }

    public static float pxToDp(float px, Context context) {
        return px / context.getResources().getDisplayMetrics().density;
    }

    public static int colorWithAlpha(int color2, float percent) {
        int r = Color.red((int)color2);
        int g = Color.green((int)color2);
        int b = Color.blue((int)color2);
        int alpha = Math.round(percent * 255.0f);
        return Color.argb((int)alpha, (int)r, (int)g, (int)b);
    }

    public static float minMax(float min, float value, float max) {
        value = Math.min(value, max);
        value = Math.max(min, value);
        return value;
    }

    public static void setScale(float scale, View ... views) {
        for (View view : views) {
            if (view == null) continue;
            ViewHelper.setScaleX((View)view, (float)scale);
            ViewHelper.setScaleY((View)view, (float)scale);
        }
    }

    public static void setElevation(float elevation, View ... views) {
        for (View view : views) {
            if (view == null) continue;
            ViewCompat.setElevation((View)view, (float)elevation);
        }
    }

    public static void setBackgroundColor(int color2, View ... views) {
        for (View view : views) {
            if (view == null) continue;
            view.setBackgroundColor(color2);
        }
    }
}

