/*
 * Decompiled with CFR 0.152.
 */
package com.jillesvangurp.eskotlinwrapper;

import com.jillesvangurp.eskotlinwrapper.BulkIndexingSession;
import com.jillesvangurp.eskotlinwrapper.BulkOperation;
import com.jillesvangurp.eskotlinwrapper.IndexRepository;
import com.jillesvangurp.eskotlinwrapper.IndexRepositoryKt;
import com.jillesvangurp.eskotlinwrapper.ModelReaderAndWriter;
import com.jillesvangurp.eskotlinwrapper.PagedSearchResults;
import com.jillesvangurp.eskotlinwrapper.ScrollingSearchResults;
import com.jillesvangurp.eskotlinwrapper.SearchResults;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RandomUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.KotlinExtensionsKt;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002Bc\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u0012\b\b\u0002\u0010\r\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0082\u0001\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020$2\"\b\u0002\u0010%\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000'\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u001f\u0018\u00010&28\u0010)\u001a4\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000*\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000*\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u001f0&\u00a2\u0006\u0002\b.JX\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000*2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020$2\"\b\u0002\u0010%\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000'\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u001f\u0018\u00010&2\b\b\u0002\u00100\u001a\u00020\u0011J+\u00101\u001a\u0002022\b\b\u0002\u00100\u001a\u00020\u00112\u0019\b\u0002\u00103\u001a\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u001f04\u00a2\u0006\u0002\b.J5\u00106\u001a\u00020\u001f2\b\b\u0002\u00100\u001a\u00020\u00112\n\b\u0002\u00107\u001a\u0004\u0018\u0001082\u0017\u00103\u001a\u0013\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001f04\u00a2\u0006\u0002\b.J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\b\b\u0002\u00100\u001a\u00020\u0011J\u0018\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\u00042\b\b\u0002\u00100\u001a\u00020\u0011J\u0010\u0010?\u001a\u00020\n2\b\b\u0002\u00100\u001a\u00020\u0011J\u0015\u0010@\u001a\u0004\u0018\u00018\u00002\u0006\u0010>\u001a\u00020\u0004\u00a2\u0006\u0002\u0010AJ\u000e\u0010B\u001a\n D*\u0004\u0018\u00010C0CJ\u000e\u0010E\u001a\n D*\u0004\u0018\u00010F0FJ\u000e\u0010G\u001a\n D*\u0004\u0018\u00010H0HJ&\u0010I\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020K\u0018\u00010J2\u0006\u0010>\u001a\u00020\u00042\b\b\u0002\u00100\u001a\u00020\u0011JK\u0010L\u001a\u00020M2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u00042\u0006\u0010N\u001a\u00028\u00002\b\b\u0002\u0010O\u001a\u00020\n2\n\b\u0002\u0010P\u001a\u0004\u0018\u0001022\n\b\u0002\u0010Q\u001a\u0004\u0018\u0001022\b\b\u0002\u00100\u001a\u00020\u0011\u00a2\u0006\u0002\u0010RJ\u0006\u0010S\u001a\u00020\u001fJC\u0010T\u001a\b\u0012\u0004\u0012\u00028\u00000U2\b\b\u0002\u0010V\u001a\u00020\n2\b\b\u0002\u0010W\u001a\u0002022\b\b\u0002\u00100\u001a\u00020\u00112\u0017\u00103\u001a\u0013\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020\u001f04\u00a2\u0006\u0002\b.J<\u0010Y\u001a\u00020M2\u0006\u0010Z\u001a\u00020!2\u0006\u0010>\u001a\u00020\u00042\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000042\u0006\u0010\\\u001a\u00020!2\u0006\u00100\u001a\u00020\u0011H\u0002J6\u0010Y\u001a\u00020M2\u0006\u0010>\u001a\u00020\u00042\b\b\u0002\u0010\\\u001a\u00020!2\b\b\u0002\u00100\u001a\u00020\u00112\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u0016\u00a8\u0006]"}, d2={"Lcom/jillesvangurp/eskotlinwrapper/IndexRepository;", "T", "", "indexName", "", "client", "Lorg/elasticsearch/client/RestHighLevelClient;", "modelReaderAndWriter", "Lcom/jillesvangurp/eskotlinwrapper/ModelReaderAndWriter;", "refreshAllowed", "", "type", "indexWriteAlias", "indexReadAlias", "fetchSourceContext", "Lorg/elasticsearch/search/fetch/subphase/FetchSourceContext;", "defaultRequestOptions", "Lorg/elasticsearch/client/RequestOptions;", "(Ljava/lang/String;Lorg/elasticsearch/client/RestHighLevelClient;Lcom/jillesvangurp/eskotlinwrapper/ModelReaderAndWriter;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/elasticsearch/search/fetch/subphase/FetchSourceContext;Lorg/elasticsearch/client/RequestOptions;)V", "getDefaultRequestOptions$build", "()Lorg/elasticsearch/client/RequestOptions;", "getIndexName", "()Ljava/lang/String;", "getIndexReadAlias", "getIndexWriteAlias", "getModelReaderAndWriter$build", "()Lcom/jillesvangurp/eskotlinwrapper/ModelReaderAndWriter;", "getType$annotations", "()V", "getType", "bulk", "", "bulkSize", "", "retryConflictingUpdates", "refreshPolicy", "Lorg/elasticsearch/action/support/WriteRequest$RefreshPolicy;", "itemCallback", "Lkotlin/Function2;", "Lcom/jillesvangurp/eskotlinwrapper/BulkOperation;", "Lorg/elasticsearch/action/bulk/BulkItemResponse;", "operationsBlock", "Lcom/jillesvangurp/eskotlinwrapper/BulkIndexingSession;", "Lkotlin/ParameterName;", "name", "session", "Lkotlin/ExtensionFunctionType;", "bulkIndexer", "requestOptions", "count", "", "block", "Lkotlin/Function1;", "Lorg/elasticsearch/client/core/CountRequest;", "createIndex", "waitForActiveShards", "Lorg/elasticsearch/action/support/ActiveShardCount;", "Lorg/elasticsearch/client/indices/CreateIndexRequest;", "currentAliases", "", "Lorg/elasticsearch/cluster/metadata/AliasMetadata;", "delete", "id", "deleteIndex", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "getMappings", "Lorg/elasticsearch/client/indices/GetMappingsResponse;", "kotlin.jvm.PlatformType", "getMappingsAndSettings", "Lorg/elasticsearch/client/indices/GetIndexResponse;", "getSettings", "Lorg/elasticsearch/action/admin/indices/settings/get/GetSettingsResponse;", "getWithGetResponse", "Lkotlin/Pair;", "Lorg/elasticsearch/action/get/GetResponse;", "index", "Lorg/elasticsearch/action/index/IndexResponse;", "obj", "create", "seqNo", "primaryTerm", "(Ljava/lang/String;Ljava/lang/Object;ZLjava/lang/Long;Ljava/lang/Long;Lorg/elasticsearch/client/RequestOptions;)Lorg/elasticsearch/action/index/IndexResponse;", "refresh", "search", "Lcom/jillesvangurp/eskotlinwrapper/SearchResults;", "scrolling", "scrollTtlInMinutes", "Lorg/elasticsearch/action/search/SearchRequest;", "update", "tries", "transformFunction", "maxUpdateTries", "build"})
public final class IndexRepository<T> {
    @NotNull
    private final String indexName;
    private final RestHighLevelClient client;
    @NotNull
    private final ModelReaderAndWriter<T> modelReaderAndWriter;
    private final boolean refreshAllowed;
    @Nullable
    private final String type;
    @NotNull
    private final String indexWriteAlias;
    @NotNull
    private final String indexReadAlias;
    private final FetchSourceContext fetchSourceContext;
    @NotNull
    private final RequestOptions defaultRequestOptions;

    public final void createIndex(@NotNull RequestOptions requestOptions, @Nullable ActiveShardCount waitForActiveShards, @NotNull Function1<? super CreateIndexRequest, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        CreateIndexRequest indexRequest = new CreateIndexRequest(this.indexName);
        if (waitForActiveShards != null) {
            indexRequest.waitForActiveShards(waitForActiveShards);
        }
        block.invoke((Object)indexRequest);
        this.client.indices().create(indexRequest, requestOptions);
    }

    public static /* synthetic */ void createIndex$default(IndexRepository indexRepository, RequestOptions requestOptions, ActiveShardCount activeShardCount, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        if ((n & 2) != 0) {
            activeShardCount = null;
        }
        indexRepository.createIndex(requestOptions, activeShardCount, (Function1<CreateIndexRequest, Unit>)function1);
    }

    public final GetSettingsResponse getSettings() {
        return this.client.indices().getSettings(new GetSettingsRequest().indices(new String[]{this.indexName}), this.defaultRequestOptions);
    }

    public final GetMappingsResponse getMappings() {
        return this.client.indices().getMapping(new GetMappingsRequest().indices(new String[]{this.indexName}), this.defaultRequestOptions);
    }

    public final GetIndexResponse getMappingsAndSettings() {
        return this.client.indices().get(new GetIndexRequest(new String[]{this.indexName}), this.defaultRequestOptions);
    }

    public final boolean deleteIndex(@NotNull RequestOptions requestOptions) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        try {
            this.client.indices().delete(new DeleteIndexRequest(this.indexName), requestOptions);
            bl = true;
        }
        catch (ElasticsearchStatusException e) {
            RestStatus restStatus = e.status();
            Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"e.status()");
            if (restStatus.getStatus() != 404) {
                throw (Throwable)e;
            }
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean deleteIndex$default(IndexRepository indexRepository, RequestOptions requestOptions, int n, Object object) {
        if ((n & 1) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        return indexRepository.deleteIndex(requestOptions);
    }

    @NotNull
    public final Set<AliasMetadata> currentAliases(@NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        GetAliasesResponse getAliasesResponse = this.client.indices().getAlias(new GetAliasesRequest().indices(new String[]{this.indexName}), requestOptions);
        Intrinsics.checkNotNullExpressionValue((Object)getAliasesResponse, (String)"client.indices().getAlia\u2026dexName), requestOptions)");
        Set set = (Set)getAliasesResponse.getAliases().get(this.indexName);
        if (set == null) {
            throw (Throwable)new IllegalStateException("Inde " + this.indexName + " does not exist");
        }
        return set;
    }

    public static /* synthetic */ Set currentAliases$default(IndexRepository indexRepository, RequestOptions requestOptions, int n, Object object) {
        if ((n & 1) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        return indexRepository.currentAliases(requestOptions);
    }

    @NotNull
    public final IndexResponse index(@Nullable String id, @NotNull T obj, boolean create2, @Nullable Long seqNo, @Nullable Long primaryTerm, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = ((IndexRequest)new IndexRequest().index(this.indexWriteAlias)).source(this.modelReaderAndWriter.serialize(obj), XContentType.JSON);
        boolean bl = false;
        boolean bl2 = false;
        IndexRequest it = object;
        boolean bl3 = false;
        IndexRequest indexRequest = id != null ? it.id(id).create(create2) : it;
        object = this.type;
        bl = false;
        bl2 = false;
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            indexRequest.type(this.type);
        }
        if (seqNo != null) {
            indexRequest.setIfSeqNo(seqNo.longValue());
            Long l = primaryTerm;
            if (l == null) {
                throw (Throwable)new IllegalArgumentException("you must also set primaryTerm when setting a seqNo");
            }
            indexRequest.setIfPrimaryTerm(l.longValue());
        }
        IndexResponse indexResponse = this.client.index(indexRequest, requestOptions);
        Intrinsics.checkNotNullExpressionValue((Object)indexResponse, (String)"client.index(\n          \u2026 requestOptions\n        )");
        return indexResponse;
    }

    public static /* synthetic */ IndexResponse index$default(IndexRepository indexRepository, String string, Object object, boolean bl, Long l, Long l2, RequestOptions requestOptions, int n, Object object2) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            l = null;
        }
        if ((n & 0x10) != 0) {
            l2 = null;
        }
        if ((n & 0x20) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        return indexRepository.index(string, object, bl, l, l2, requestOptions);
    }

    @NotNull
    public final IndexResponse update(@NotNull String id, int maxUpdateTries, @NotNull RequestOptions requestOptions, @NotNull Function1<? super T, ? extends T> transformFunction) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkNotNullParameter(transformFunction, (String)"transformFunction");
        return this.update(0, id, transformFunction, maxUpdateTries, requestOptions);
    }

    public static /* synthetic */ IndexResponse update$default(IndexRepository indexRepository, String string, int n, RequestOptions requestOptions, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        return indexRepository.update(string, n, requestOptions, function1);
    }

    private final IndexResponse update(int tries, String id, Function1<? super T, ? extends T> transformFunction, int maxUpdateTries, RequestOptions requestOptions) {
        try {
            GetResponse response;
            GetRequest getRequest = ((GetRequest)new GetRequest().index(this.indexWriteAlias)).id(id);
            CharSequence charSequence = this.type;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                getRequest.type(this.type);
            }
            GetResponse getResponse = response = this.client.get(getRequest, requestOptions);
            Intrinsics.checkNotNullExpressionValue((Object)getResponse, (String)"response");
            byte[] sourceAsBytes = getResponse.getSourceAsBytes();
            if (sourceAsBytes != null) {
                T currentValue = this.modelReaderAndWriter.deserialize(sourceAsBytes);
                Object transformed = transformFunction.invoke(currentValue);
                IndexResponse indexResponse = IndexRepository.index$default(this, id, transformed, false, response.getSeqNo(), response.getPrimaryTerm(), null, 32, null);
                if (tries > 0) {
                    IndexRepositoryKt.access$getLogger$p().warn((Function0)new Function0<Object>(id, tries){
                        final /* synthetic */ String $id;
                        final /* synthetic */ int $tries;

                        @Nullable
                        public final Object invoke() {
                            return "retry update " + this.$id + " succeeded after tries=" + this.$tries;
                        }
                        {
                            this.$id = string;
                            this.$tries = n;
                            super(0);
                        }
                    });
                }
                return indexResponse;
            }
            throw (Throwable)new IllegalStateException("id " + id + " not found");
        }
        catch (ElasticsearchStatusException e) {
            RestStatus restStatus = e.status();
            Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"e.status()");
            if (restStatus.getStatus() == 409) {
                if (tries < maxUpdateTries) {
                    Thread.sleep(RandomUtils.nextLong((long)50L, (long)500L));
                    return this.update(tries + 1, id, transformFunction, maxUpdateTries, requestOptions);
                }
                throw (Throwable)new IllegalStateException("update of " + id + " failed after " + tries + " attempts");
            }
            throw (Throwable)e;
        }
    }

    public final void delete(@NotNull String id, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(this.indexWriteAlias)).id(id);
        CharSequence charSequence = this.type;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            deleteRequest.type(this.type);
        }
        this.client.delete(deleteRequest, requestOptions);
    }

    public static /* synthetic */ void delete$default(IndexRepository indexRepository, String string, RequestOptions requestOptions, int n, Object object) {
        if ((n & 2) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        indexRepository.delete(string, requestOptions);
    }

    @Nullable
    public final T get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Pair pair = IndexRepository.getWithGetResponse$default(this, id, null, 2, null);
        return (T)(pair != null ? pair.getFirst() : null);
    }

    @Nullable
    public final Pair<T, GetResponse> getWithGetResponse(@NotNull String id, @NotNull RequestOptions requestOptions) {
        GetResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        GetRequest getRequest = ((GetRequest)new GetRequest().index(this.indexReadAlias)).id(id);
        if (this.fetchSourceContext != null) {
            getRequest.fetchSourceContext(this.fetchSourceContext);
        }
        CharSequence charSequence = this.type;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            getRequest.type(this.type);
        }
        GetResponse getResponse = response = this.client.get(getRequest, requestOptions);
        Intrinsics.checkNotNullExpressionValue((Object)getResponse, (String)"response");
        byte[] sourceAsBytes = getResponse.getSourceAsBytes();
        if (sourceAsBytes != null) {
            T deserialized = this.modelReaderAndWriter.deserialize(sourceAsBytes);
            return new Pair(deserialized, (Object)response);
        }
        return null;
    }

    public static /* synthetic */ Pair getWithGetResponse$default(IndexRepository indexRepository, String string, RequestOptions requestOptions, int n, Object object) {
        if ((n & 2) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        return indexRepository.getWithGetResponse(string, requestOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bulk(int bulkSize, int retryConflictingUpdates, @NotNull WriteRequest.RefreshPolicy refreshPolicy, @Nullable Function2<? super BulkOperation<T>, ? super BulkItemResponse, Unit> itemCallback, @NotNull Function2<? super BulkIndexingSession<T>, ? super BulkIndexingSession<T>, Unit> operationsBlock) {
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        Intrinsics.checkNotNullParameter(operationsBlock, (String)"operationsBlock");
        BulkIndexingSession indexer = IndexRepository.bulkIndexer$default(this, bulkSize, retryConflictingUpdates, refreshPolicy, itemCallback, null, 16, null);
        AutoCloseable autoCloseable = indexer;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BulkIndexingSession it = (BulkIndexingSession)autoCloseable;
            boolean bl3 = false;
            operationsBlock.invoke((Object)indexer, (Object)indexer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void bulk$default(IndexRepository indexRepository, int n, int n2, WriteRequest.RefreshPolicy refreshPolicy, Function2 function2, Function2 function22, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 100;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            refreshPolicy = WriteRequest.RefreshPolicy.WAIT_UNTIL;
        }
        if ((n3 & 8) != 0) {
            function2 = null;
        }
        indexRepository.bulk(n, n2, refreshPolicy, function2, function22);
    }

    @NotNull
    public final BulkIndexingSession<T> bulkIndexer(int bulkSize, int retryConflictingUpdates, @NotNull WriteRequest.RefreshPolicy refreshPolicy, @Nullable Function2<? super BulkOperation<T>, ? super BulkItemResponse, Unit> itemCallback, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return new BulkIndexingSession<T>(this.client, this, this.modelReaderAndWriter, bulkSize, retryConflictingUpdates, refreshPolicy, itemCallback, requestOptions);
    }

    public static /* synthetic */ BulkIndexingSession bulkIndexer$default(IndexRepository indexRepository, int n, int n2, WriteRequest.RefreshPolicy refreshPolicy, Function2 function2, RequestOptions requestOptions, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 100;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            refreshPolicy = WriteRequest.RefreshPolicy.WAIT_UNTIL;
        }
        if ((n3 & 8) != 0) {
            function2 = null;
        }
        if ((n3 & 0x10) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        return indexRepository.bulkIndexer(n, n2, refreshPolicy, function2, requestOptions);
    }

    public final void refresh() {
        if (!this.refreshAllowed) {
            throw (Throwable)new UnsupportedOperationException("refresh is not allowed; you need to opt in by setting refreshAllowed to true");
        }
        this.client.getLowLevelClient().performRequest(new Request("POST", '/' + this.indexWriteAlias + "/_refresh"));
    }

    @NotNull
    public final SearchResults<T> search(boolean scrolling, long scrollTtlInMinutes, @NotNull RequestOptions requestOptions, @NotNull Function1<? super SearchRequest, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Function1 wrappedBlock2 = (Function1)new Function1<SearchRequest, Unit>(this, scrolling, scrollTtlInMinutes, block){
            final /* synthetic */ IndexRepository this$0;
            final /* synthetic */ boolean $scrolling;
            final /* synthetic */ long $scrollTtlInMinutes;
            final /* synthetic */ Function1 $block;

            public final void invoke(@NotNull SearchRequest $receiver) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                    $receiver.indices(new String[]{this.this$0.getIndexReadAlias()});
                    if (this.$scrolling) {
                        $receiver.scroll(TimeValue.timeValueMinutes((long)this.$scrollTtlInMinutes));
                    }
                    this.$block.invoke((Object)$receiver);
                    if (IndexRepository.access$getFetchSourceContext$p(this.this$0) == null) break block3;
                    SearchSourceBuilder searchSourceBuilder = $receiver.source();
                    if ((searchSourceBuilder != null ? searchSourceBuilder.fetchSource() : null) == null) {
                        SearchSourceBuilder searchSourceBuilder2 = $receiver.source();
                        if (searchSourceBuilder2 != null) {
                            searchSourceBuilder2.fetchSource(IndexRepository.access$getFetchSourceContext$p(this.this$0));
                        }
                    }
                }
            }
            {
                this.this$0 = indexRepository;
                this.$scrolling = bl;
                this.$scrollTtlInMinutes = l;
                this.$block = function1;
                super(1);
            }
        };
        SearchResponse searchResponse2 = KotlinExtensionsKt.search(this.client, requestOptions, (Function1<? super SearchRequest, Unit>)wrappedBlock2);
        return searchResponse2.getScrollId() == null ? (SearchResults)new PagedSearchResults<T>(searchResponse2, this.modelReaderAndWriter) : (SearchResults)new ScrollingSearchResults<T>(searchResponse2, this.modelReaderAndWriter, this.client, scrollTtlInMinutes, requestOptions);
    }

    public static /* synthetic */ SearchResults search$default(IndexRepository indexRepository, boolean bl, long l, RequestOptions requestOptions, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            l = 1L;
        }
        if ((n & 4) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        return indexRepository.search(bl, l, requestOptions, (Function1<SearchRequest, Unit>)function1);
    }

    public final long count(@NotNull RequestOptions requestOptions, @NotNull Function1<? super CountRequest, Unit> block) {
        CountResponse response;
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        CountRequest request = new CountRequest(new String[]{this.indexReadAlias});
        block.invoke((Object)request);
        CountResponse countResponse = response = this.client.count(request, requestOptions);
        Intrinsics.checkNotNullExpressionValue((Object)countResponse, (String)"response");
        return countResponse.getCount();
    }

    public static /* synthetic */ long count$default(IndexRepository indexRepository, RequestOptions requestOptions, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            requestOptions = indexRepository.defaultRequestOptions;
        }
        if ((n & 2) != 0) {
            function1 = count.1.INSTANCE;
        }
        return indexRepository.count(requestOptions, (Function1<CountRequest, Unit>)function1);
    }

    @NotNull
    public final String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public final ModelReaderAndWriter<T> getModelReaderAndWriter$build() {
        return this.modelReaderAndWriter;
    }

    @Deprecated(message="Types are deprecated in ES 7.x and will be removed in v8")
    public static /* synthetic */ void getType$annotations() {
    }

    @Nullable
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getIndexWriteAlias() {
        return this.indexWriteAlias;
    }

    @NotNull
    public final String getIndexReadAlias() {
        return this.indexReadAlias;
    }

    @NotNull
    public final RequestOptions getDefaultRequestOptions$build() {
        return this.defaultRequestOptions;
    }

    public IndexRepository(@NotNull String indexName, @NotNull RestHighLevelClient client, @NotNull ModelReaderAndWriter<T> modelReaderAndWriter, boolean refreshAllowed, @Nullable String type, @NotNull String indexWriteAlias, @NotNull String indexReadAlias, @Nullable FetchSourceContext fetchSourceContext, @NotNull RequestOptions defaultRequestOptions) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(modelReaderAndWriter, (String)"modelReaderAndWriter");
        Intrinsics.checkNotNullParameter((Object)indexWriteAlias, (String)"indexWriteAlias");
        Intrinsics.checkNotNullParameter((Object)indexReadAlias, (String)"indexReadAlias");
        Intrinsics.checkNotNullParameter((Object)defaultRequestOptions, (String)"defaultRequestOptions");
        this.indexName = indexName;
        this.client = client;
        this.modelReaderAndWriter = modelReaderAndWriter;
        this.refreshAllowed = refreshAllowed;
        this.type = type;
        this.indexWriteAlias = indexWriteAlias;
        this.indexReadAlias = indexReadAlias;
        this.fetchSourceContext = fetchSourceContext;
        this.defaultRequestOptions = defaultRequestOptions;
    }

    public /* synthetic */ IndexRepository(String string, RestHighLevelClient restHighLevelClient, ModelReaderAndWriter modelReaderAndWriter, boolean bl, String string2, String string3, String string4, FetchSourceContext fetchSourceContext, RequestOptions requestOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = string;
        }
        if ((n & 0x40) != 0) {
            string4 = string3;
        }
        if ((n & 0x80) != 0) {
            fetchSourceContext = null;
        }
        if ((n & 0x100) != 0) {
            RequestOptions requestOptions2 = RequestOptions.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)requestOptions2, (String)"RequestOptions.DEFAULT");
            requestOptions = requestOptions2;
        }
        this(string, restHighLevelClient, modelReaderAndWriter, bl, string2, string3, string4, fetchSourceContext, requestOptions);
    }

    public static final /* synthetic */ FetchSourceContext access$getFetchSourceContext$p(IndexRepository $this) {
        return $this.fetchSourceContext;
    }
}

