/*
 * Decompiled with CFR 0.152.
 */
package com.moczul.ok2curl;

import com.moczul.ok2curl.CurlBuilder;
import com.moczul.ok2curl.Options;
import com.moczul.ok2curl.logger.Loggable;
import com.moczul.ok2curl.modifier.HeaderModifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class CurlInterceptor
implements Interceptor {
    private static final long DEFAULT_LIMIT = 0x100000L;
    private final Loggable logger;
    private final long limit;
    private final List<HeaderModifier> headerModifiers = new ArrayList<HeaderModifier>();
    private final Options options;

    public CurlInterceptor(Loggable logger) {
        this(logger, 0x100000L, Collections.emptyList(), Options.EMPTY);
    }

    public CurlInterceptor(Loggable logger, Options options) {
        this(logger, 0x100000L, Collections.emptyList(), options);
    }

    public CurlInterceptor(Loggable logger, List<HeaderModifier> headerModifiers) {
        this(logger, 0x100000L, headerModifiers, Options.EMPTY);
    }

    public CurlInterceptor(Loggable logger, long limit) {
        this(logger, limit, Collections.emptyList(), Options.EMPTY);
    }

    public CurlInterceptor(Loggable logger, long limit, List<HeaderModifier> headerModifiers, Options options) {
        this.logger = logger;
        this.limit = limit;
        this.headerModifiers.addAll(headerModifiers);
        this.options = options;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request copy = request.newBuilder().build();
        String curl = new CurlBuilder(copy, this.limit, this.headerModifiers, this.options).build();
        this.logger.log(curl);
        return chain.proceed(request);
    }
}

