/*
 * Decompiled with CFR 0.152.
 */
package com.github.nwillc.ksvg.elements;

import com.github.nwillc.ksvg.HtmlUtilsKt;
import com.github.nwillc.ksvg.attributes.AttributeType;
import com.github.nwillc.ksvg.attributes.RenamedAttribute;
import com.github.nwillc.ksvg.attributes.TypedAttribute;
import com.github.nwillc.ksvg.elements.SVG;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010%\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020\u00002\u0006\u0010'\u001a\u0002H&2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0002\b+H\u0004\u00a2\u0006\u0002\u0010,J\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030-2\u0006\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020\u0005J\u0006\u00101\u001a\u00020\u0005J\u0006\u00102\u001a\u00020\u0005J\u0018\u00103\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u0010.\u001a\u00020/H\u0016J\b\u00106\u001a\u00020\u0003H\u0016R1\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bj\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u0012j\b\u0012\u0004\u0012\u00020\u0000`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R/\u0010\u0017\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R/\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00067"}, d2={"Lcom/github/nwillc/ksvg/elements/Element;", "", "name", "", "validation", "", "(Ljava/lang/String;Z)V", "attributes", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAttributes", "()Ljava/util/HashMap;", "body", "getBody", "()Ljava/lang/String;", "setBody", "(Ljava/lang/String;)V", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getChildren", "()Ljava/util/ArrayList;", "<set-?>", "cssClass", "getCssClass", "setCssClass", "cssClass$delegate", "Lcom/github/nwillc/ksvg/attributes/RenamedAttribute;", "id", "getId", "setId", "id$delegate", "Lcom/github/nwillc/ksvg/attributes/TypedAttribute;", "getValidation", "()Z", "setValidation", "(Z)V", "add", "E", "element", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/github/nwillc/ksvg/elements/Element;Lkotlin/jvm/functions/Function1;)Lcom/github/nwillc/ksvg/elements/Element;", "", "renderMode", "Lcom/github/nwillc/ksvg/elements/SVG$RenderMode;", "hasBody", "hasChildren", "hasContent", "render", "writer", "Ljava/io/Writer;", "toString", "ksvg"})
public abstract class Element {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final HashMap<String, String> attributes;
    @NotNull
    private final ArrayList<Element> children;
    @Nullable
    private final TypedAttribute id$delegate;
    @Nullable
    private final RenamedAttribute cssClass$delegate;
    @NotNull
    private String body;
    private final String name;
    private boolean validation;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Element.class), "id", "getId()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Element.class), "cssClass", "getCssClass()Ljava/lang/String;"))};
    }

    @NotNull
    public final HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final ArrayList<Element> getChildren() {
        return this.children;
    }

    @Nullable
    public final String getId() {
        return this.id$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setId(@Nullable String string) {
        this.id$delegate.setValue((Object)this, $$delegatedProperties[0], string);
    }

    @Nullable
    public final String getCssClass() {
        return this.cssClass$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setCssClass(@Nullable String string) {
        this.cssClass$delegate.setValue((Object)this, $$delegatedProperties[1], string);
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    public final void setBody(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.body = string;
    }

    @NotNull
    protected final <E extends Element> E add(@NotNull E element, @NotNull Function1<? super E, Unit> block) {
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        block.invoke(element);
        this.children.add(element);
        return element;
    }

    @NotNull
    public Map<String, String> getAttributes(@NotNull SVG.RenderMode renderMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)renderMode), (String)"renderMode");
        return this.attributes;
    }

    public void render(@NotNull Writer writer, @NotNull SVG.RenderMode renderMode) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)((Object)renderMode), (String)"renderMode");
        writer.append('<' + this.name);
        Iterable $receiver$iv = this.getAttributes(renderMode).entrySet();
        for (Object element$iv : $receiver$iv) {
            it = (Map.Entry)element$iv;
            writer.append(' ');
            writer.append((CharSequence)it.getKey());
            writer.append("=\"");
            writer.append((CharSequence)it.getValue());
            writer.append('\"');
        }
        if (!this.hasContent()) {
            writer.append("/>\n");
        } else {
            writer.append('>');
            if (this.hasBody()) {
                writer.append(HtmlUtilsKt.escapeHTML(this.body));
            } else {
                writer.append('\n');
            }
            $receiver$iv = this.children;
            for (Object element$iv : $receiver$iv) {
                it = (Element)element$iv;
                ((Element)it).render(writer, renderMode);
            }
            writer.append("</" + this.name + ">\n");
        }
    }

    public final boolean hasBody() {
        CharSequence charSequence = this.body;
        return charSequence.length() > 0;
    }

    public final boolean hasChildren() {
        Collection collection = this.children;
        return !collection.isEmpty();
    }

    public final boolean hasContent() {
        return this.hasBody() || this.hasChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String toString() {
        String string;
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter it = (StringWriter)closeable;
            this.render(it, SVG.RenderMode.INLINE);
            String string2 = it.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.toString()");
            String string3 = string2;
            string = string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringWriter().use {\n   \u2026.toString()\n            }");
        return string;
    }

    public final boolean getValidation() {
        return this.validation;
    }

    public final void setValidation(boolean bl) {
        this.validation = bl;
    }

    public Element(@NotNull String name, boolean validation) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        this.validation = validation;
        Element element = this;
        Cloneable cloneable = new HashMap();
        element.attributes = cloneable;
        element = this;
        cloneable = new ArrayList();
        element.children = cloneable;
        this.id$delegate = new TypedAttribute(AttributeType.IdName);
        this.cssClass$delegate = new RenamedAttribute("class", null, 2, null);
        this.body = "";
    }
}

