/*
 * Decompiled with CFR 0.152.
 */
package com.github.ricardomatias;

import com.github.ricardomatias.DelaunatorKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b$\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bH\u0002J\u0018\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bH\u0002J\u0018\u00101\u001a\u0002022\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0002J\u0006\u00103\u001a\u000202R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010\u0014R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/github/ricardomatias/Delaunator;", "", "coords", "", "([D)V", "_halfedges", "", "_triangles", "getCoords", "()[D", "count", "", "cx", "", "cy", "dists", "halfedges", "getHalfedges", "()[I", "setHalfedges", "([I)V", "hashSize", "hull", "getHull", "setHull", "hullHash", "hullNext", "hullPrev", "hullStart", "hullTri", "ids", "maxTriangles", "getMaxTriangles", "()I", "triangles", "getTriangles", "setTriangles", "trianglesLen", "addTriangle", "i0", "i1", "i2", "a", "b", "c", "hashKey", "x", "y", "legalize", "link", "", "update", "delaunator"})
public final class Delaunator {
    private int count;
    private final int maxTriangles;
    private final int[] _triangles;
    private final int[] _halfedges;
    public int[] triangles;
    public int[] halfedges;
    private int hashSize;
    private int[] hullPrev;
    private int[] hullNext;
    private int[] hullTri;
    private int[] hullHash;
    private int hullStart;
    private int[] ids;
    private double[] dists;
    private double cx;
    private double cy;
    private int trianglesLen;
    public int[] hull;
    @NotNull
    private final double[] coords;

    public final int getMaxTriangles() {
        return this.maxTriangles;
    }

    @NotNull
    public final int[] getTriangles() {
        if (this.triangles == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"triangles");
        }
        return this.triangles;
    }

    public final void setTriangles(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.triangles = nArray;
    }

    @NotNull
    public final int[] getHalfedges() {
        if (this.halfedges == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"halfedges");
        }
        return this.halfedges;
    }

    public final void setHalfedges(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.halfedges = nArray;
    }

    @NotNull
    public final int[] getHull() {
        if (this.hull == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hull");
        }
        return this.hull;
    }

    public final void setHull(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.hull = nArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void update() {
        int i;
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        int n = 0;
        int n2 = this.count;
        while (n < n2) {
            void i2;
            double x = this.coords[2 * i2];
            double y = this.coords[2 * i2 + 1];
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            this.ids[i2] = i2;
            ++i2;
        }
        double cx = (minX + maxX) / (double)2;
        double cy = (minY + maxY) / (double)2;
        double minDist = Double.POSITIVE_INFINITY;
        int i0 = -1;
        int i1 = -1;
        int i2 = -1;
        int n3 = 0;
        int n4 = this.count;
        while (n3 < n4) {
            void i3;
            double d = DelaunatorKt.access$dist(cx, cy, this.coords[2 * i3], this.coords[2 * i3 + 1]);
            if (d < minDist) {
                i0 = i3;
                minDist = d;
            }
            ++i3;
        }
        double i0x = this.coords[2 * i0];
        double i0y = this.coords[2 * i0 + 1];
        minDist = Double.POSITIVE_INFINITY;
        int n5 = 0;
        int n6 = this.count;
        while (n5 < n6) {
            double d;
            void i4;
            if (i4 != i0 && (d = DelaunatorKt.access$dist(i0x, i0y, this.coords[2 * i4], this.coords[2 * i4 + 1])) < minDist && d > 0.0) {
                i1 = i4;
                minDist = d;
            }
            ++i4;
        }
        double i1x = this.coords[2 * i1];
        double i1y = this.coords[2 * i1 + 1];
        double minRadius = Double.POSITIVE_INFINITY;
        int n7 = 0;
        int n8 = this.count;
        while (n7 < n8) {
            double r;
            if (i != i0 && i != i1 && (r = DelaunatorKt.circumradius(i0x, i0y, i1x, i1y, this.coords[2 * i], this.coords[2 * i + 1])) < minRadius) {
                i2 = i;
                minRadius = r;
            }
            ++i;
        }
        if (minRadius == Double.POSITIVE_INFINITY) {
            n8 = this.count;
            for (i = 0; i < n8; ++i) {
                double a = this.coords[2 * i] - this.coords[0];
                double b = this.coords[2 * i + 1] - this.coords[1];
                this.dists[i] = a == 0.0 ? b : a;
            }
            DelaunatorKt.quicksort(this.ids, this.dists, 0, this.count - 1);
            int[] nhull = new int[this.count];
            int j = 0;
            double d0 = Double.NEGATIVE_INFINITY;
            int b = 0;
            int n9 = this.count;
            while (b < n9) {
                void i5;
                int id = this.ids[i5];
                if (this.dists[id] > d0) {
                    nhull[j++] = id;
                    d0 = this.dists[id];
                }
                ++i5;
            }
            int[] i5 = nhull;
            n9 = 0;
            int[] nArray = Arrays.copyOf(i5, j);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"java.util.Arrays.copyOf(this, newSize)");
            this.hull = nArray;
            this.triangles = new int[0];
            this.halfedges = new int[0];
            return;
        }
        double i2x = this.coords[2 * i2];
        double i2y = this.coords[2 * i2 + 1];
        if (DelaunatorKt.access$orient(i0x, i0y, i1x, i1y, i2x, i2y) < 0.0) {
            int i6 = i1;
            double x = i1x;
            double y = i1y;
            i1 = i2;
            i1x = i2x;
            i1y = i2y;
            i2 = i6;
            i2x = x;
            i2y = y;
        }
        double[] center = DelaunatorKt.circumcenter(i0x, i0y, i1x, i1y, i2x, i2y);
        this.cx = center[0];
        this.cy = center[1];
        int x = 0;
        int id = this.count;
        while (x < id) {
            void i7;
            this.dists[i7] = DelaunatorKt.access$dist(this.coords[2 * i7], this.coords[2 * i7 + 1], center[0], center[1]);
            ++i7;
        }
        DelaunatorKt.quicksort(this.ids, this.dists, 0, this.count - 1);
        this.hullStart = i0;
        int hullSize = 3;
        this.hullNext[i0] = i1;
        this.hullNext[i1] = i2;
        this.hullNext[i2] = i0;
        this.hullPrev[i2] = i1;
        this.hullPrev[i0] = i2;
        this.hullPrev[i1] = i0;
        this.hullTri[i0] = 0;
        this.hullTri[i1] = 1;
        this.hullTri[i2] = 2;
        ArraysKt.fill$default((int[])this.hullHash, (int)-1, (int)0, (int)0, (int)6, null);
        this.hullHash[this.hashKey((double)i0x, (double)i0y)] = i0;
        this.hullHash[this.hashKey((double)i1x, (double)i1y)] = i1;
        this.hullHash[this.hashKey((double)i2x, (double)i2y)] = i2;
        this.trianglesLen = 0;
        this.addTriangle(i0, i1, i2, -1, -1, -1);
        double xp = 0.0;
        double yp = 0.0;
        int n10 = 0;
        int n11 = this.ids.length;
        while (n10 < n11) {
            void k;
            block32: {
                int n12;
                double y;
                double x2;
                int i8;
                block31: {
                    i8 = this.ids[k];
                    x2 = this.coords[2 * i8];
                    y = this.coords[2 * i8 + 1];
                    if (k <= 0) break block31;
                    double d = x2 - xp;
                    n12 = 0;
                    if (!(Math.abs(d) <= DelaunatorKt.getEPSILON())) break block31;
                    d = y - yp;
                    n12 = 0;
                    if (Math.abs(d) <= DelaunatorKt.getEPSILON()) break block32;
                }
                xp = x2;
                yp = y;
                if (i8 != i0 && i8 != i1 && i8 != i2) {
                    void j;
                    int start = 0;
                    int key = this.hashKey(x2, y);
                    n12 = 0;
                    int n13 = this.hashSize;
                    while (n12 < n13 && ((start = this.hullHash[(key + j) % this.hashSize]) == -1 || start == this.hullNext[start])) {
                        ++j;
                    }
                    int e = start = this.hullPrev[start];
                    int q = this.hullNext[e];
                    while (DelaunatorKt.access$orient(x2, y, this.coords[2 * e], this.coords[2 * e + 1], this.coords[2 * q], this.coords[2 * q + 1]) >= 0.0) {
                        e = q;
                        if (e == start) {
                            e = -1;
                            break;
                        }
                        q = this.hullNext[e];
                    }
                    if (e != -1) {
                        int t = this.addTriangle(e, i8, this.hullNext[e], -1, -1, this.hullTri[e]);
                        this.hullTri[i8] = this.legalize(t + 2);
                        this.hullTri[e] = t;
                        ++hullSize;
                        int next = this.hullNext[e];
                        q = this.hullNext[next];
                        while (DelaunatorKt.access$orient(x2, y, this.coords[2 * next], this.coords[2 * next + 1], this.coords[2 * q], this.coords[2 * q + 1]) < 0.0) {
                            t = this.addTriangle(next, i8, q, this.hullTri[i8], -1, this.hullTri[next]);
                            this.hullTri[i8] = this.legalize(t + 2);
                            this.hullNext[next] = next;
                            --hullSize;
                            next = q;
                            q = this.hullNext[next];
                        }
                        if (e == start) {
                            q = this.hullPrev[e];
                            while (DelaunatorKt.access$orient(x2, y, this.coords[2 * q], this.coords[2 * q + 1], this.coords[2 * e], this.coords[2 * e + 1]) < 0.0) {
                                t = this.addTriangle(q, i8, e, -1, this.hullTri[e], this.hullTri[q]);
                                this.legalize(t + 2);
                                this.hullTri[q] = t;
                                this.hullNext[e] = e;
                                --hullSize;
                                e = q;
                                q = this.hullPrev[e];
                            }
                        }
                        this.hullStart = e;
                        this.hullPrev[i8] = e;
                        this.hullNext[e] = i8;
                        this.hullPrev[next] = i8;
                        this.hullNext[i8] = next;
                        this.hullHash[this.hashKey((double)x2, (double)y)] = i8;
                        this.hullHash[this.hashKey((double)this.coords[2 * e], (double)this.coords[2 * e + 1])] = e;
                    }
                }
            }
            ++k;
        }
        this.hull = new int[hullSize];
        int e = this.hullStart;
        n11 = 0;
        int n14 = hullSize;
        while (n11 < n14) {
            void i9;
            if (this.hull == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hull");
            }
            this.hull[i9] = e;
            e = this.hullNext[e];
            ++i9;
        }
        int[] nArray = this._triangles;
        n14 = this.trianglesLen;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, n14);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        this.triangles = nArray2;
        nArray = this._halfedges;
        n14 = this.trianglesLen;
        bl = false;
        int[] nArray3 = Arrays.copyOf(nArray, n14);
        Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
        this.halfedges = nArray3;
    }

    private final int legalize(int a) {
        int i = 0;
        int na = a;
        int ar = 0;
        while (true) {
            int b = this._halfedges[na];
            int a0 = na - na % 3;
            ar = a0 + (na + 2) % 3;
            if (b == -1) {
                if (i == 0) break;
                na = DelaunatorKt.getEDGE_STACK()[--i];
                continue;
            }
            int p0 = this._triangles[ar];
            int pr = this._triangles[na];
            int al = a0 + (na + 1) % 3;
            int pl = this._triangles[al];
            int b0 = b - b % 3;
            int bl = b0 + (b + 2) % 3;
            int p1 = this._triangles[bl];
            boolean illegal = DelaunatorKt.access$inCircle(this.coords[2 * p0], this.coords[2 * p0 + 1], this.coords[2 * pr], this.coords[2 * pr + 1], this.coords[2 * pl], this.coords[2 * pl + 1], this.coords[2 * p1], this.coords[2 * p1 + 1]);
            if (illegal) {
                this._triangles[na] = p1;
                this._triangles[b] = p0;
                int hbl = this._halfedges[bl];
                if (hbl == -1) {
                    int e = this.hullStart;
                    do {
                        if (this.hullTri[e] != bl) continue;
                        this.hullTri[e] = na;
                        break;
                    } while ((e = this.hullPrev[e]) != this.hullStart);
                }
                this.link(na, hbl);
                this.link(b, this._halfedges[ar]);
                this.link(ar, bl);
                int br = b0 + (b + 1) % 3;
                if (i >= DelaunatorKt.getEDGE_STACK().length) continue;
                DelaunatorKt.getEDGE_STACK()[i++] = br;
                continue;
            }
            if (i == 0) break;
            na = DelaunatorKt.getEDGE_STACK()[--i];
        }
        return ar;
    }

    private final void link(int a, int b) {
        this._halfedges[a] = b;
        if (b != -1) {
            this._halfedges[b] = a;
        }
    }

    private final int addTriangle(int i0, int i1, int i2, int a, int b, int c) {
        int t = this.trianglesLen;
        this._triangles[t] = i0;
        this._triangles[t + 1] = i1;
        this._triangles[t + 2] = i2;
        this.link(t, a);
        this.link(t + 1, b);
        this.link(t + 2, c);
        this.trianglesLen += 3;
        return t;
    }

    private final int hashKey(double x, double y) {
        double d = DelaunatorKt.access$pseudoAngle(x - this.cx, y - this.cy) * (double)this.hashSize;
        boolean bl = false;
        return (int)(Math.floor(d) % (double)this.hashSize);
    }

    @NotNull
    public final double[] getCoords() {
        return this.coords;
    }

    public Delaunator(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        this.coords = coords;
        this.count = this.coords.length >> 1;
        this.maxTriangles = RangesKt.coerceAtLeast((int)(2 * this.count - 5), (int)0);
        this._triangles = new int[this.maxTriangles * 3];
        this._halfedges = new int[this.maxTriangles * 3];
        double d = (double)this.count * 1.0;
        boolean bl = false;
        d = Math.sqrt(d);
        bl = false;
        this.hashSize = (int)Math.ceil(d);
        this.hullPrev = new int[this.count];
        this.hullNext = new int[this.count];
        this.hullTri = new int[this.count];
        this.hullHash = new int[this.hashSize];
        this.hullStart = -1;
        this.ids = new int[this.count];
        this.dists = new double[this.count];
        this.cx = Double.NaN;
        this.cy = Double.NaN;
        this.trianglesLen = -1;
        this.update();
    }
}

