/*
 * Decompiled with CFR 0.152.
 */
package com.smaspe.iterables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class _<T>
implements Iterable<T> {
    private static final Iterator EMPTY = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    };
    private Iterable<T> delegate;

    private _(Iterable<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public static <T> _<T> from(Iterable<T> delegate) {
        return new _<T>(delegate);
    }

    public static <T> _<T> iter(final T ... array) {
        return _.from(() -> new Iterator<T>(){
            public int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public T next() {
                return array[this.i++];
            }
        });
    }

    public static <T> _<T> repeat(final T value) {
        return _.from(() -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return value;
            }
        });
    }

    public static <T> _<T> chain(Iterable<T> ... iterables) {
        return _.chain(_.iter(iterables));
    }

    public static <T> _<T> chain(final Iterable<? extends Iterable<T>> iterables) {
        return _.from(() -> new Iterator<T>(){
            Iterator iterator;
            Iterator current;
            {
                this.iterator = iterables.iterator();
                this.current = EMPTY;
            }

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.iterator.hasNext()) {
                    this.current = ((Iterable)this.iterator.next()).iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public T next() {
                this.hasNext();
                return this.current.next();
            }
        });
    }

    public Iterable<T> chainWith(Iterable<T> next) {
        return _.chain(this, next);
    }

    public <R> _<R> map(Func<T, R> func) {
        return _.map(this, func);
    }

    public static <T, R> _<R> map(final Iterable<T> input, final Func<T, R> func) {
        return _.from(() -> new Iterator<R>(){
            Iterator iter;
            {
                this.iter = input.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public R next() {
                return func.call(this.iter.next());
            }
        });
    }

    public _<T> filter(Func<T, Boolean> func) {
        return _.filter(this, func);
    }

    public static <T> _<T> filter(final Iterable<T> input, final Func<T, Boolean> func) {
        return _.from(() -> new Iterator<T>(){
            boolean hasKnownNext = false;
            Iterator iter = input.iterator();
            Object nextValue = null;

            @Override
            public boolean hasNext() {
                if (this.hasKnownNext) {
                    return true;
                }
                while (this.iter.hasNext()) {
                    this.nextValue = this.iter.next();
                    if (!((Boolean)func.call(this.nextValue)).booleanValue()) continue;
                    this.hasKnownNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.hasKnownNext = false;
                    return this.nextValue;
                }
                throw new NoSuchElementException();
            }
        });
    }

    public boolean all(Func<T, Boolean> test) {
        return _.all(this, test);
    }

    public static <T> boolean all(Iterable<T> input, Func<T, Boolean> test) {
        return !_.any(input, t -> (Boolean)test.call(t) == false);
    }

    public boolean any(Func<T, Boolean> test) {
        return _.any(this, test);
    }

    public static <T> boolean any(Iterable<T> input, Func<T, Boolean> test) {
        for (T t : input) {
            if (!test.call(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public <V> _<Pair<T, V>> zip(Iterable<V> with) {
        return _.zip(this, with);
    }

    public static <U, V> _<Pair<U, V>> zip(final Iterable<U> firsts, final Iterable<V> seconds) {
        return _.from(() -> new Iterator<Pair<U, V>>(){
            Iterator iterFirst;
            Iterator iterSecond;
            {
                this.iterFirst = firsts.iterator();
                this.iterSecond = seconds.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterFirst.hasNext() && this.iterSecond.hasNext();
            }

            @Override
            public Pair<U, V> next() {
                return new Pair(this.iterFirst.next(), this.iterSecond.next());
            }
        });
    }

    public ArrayList<T> collect() {
        return _.collect(this);
    }

    public static <T> ArrayList<T> collect(Iterable<T> input) {
        ArrayList<T> res = new ArrayList<T>();
        for (T t : input) {
            res.add(t);
        }
        return res;
    }

    public static class Pair<U, V> {
        public U first;
        public V second;

        private Pair(U first, V second) {
            this.first = first;
            this.second = second;
        }
    }

    public static interface Func<T, R> {
        public R call(T var1);
    }
}

