/*
 * Decompiled with CFR 0.152.
 */
package com.smaspe.iterables;

import com.smaspe.iterables.FuncIter$$Lambda$1;
import com.smaspe.iterables.FuncIter$$Lambda$4;
import com.smaspe.iterables.FuncIter$$Lambda$5;
import com.smaspe.iterables.FuncIter$$Lambda$6;
import com.smaspe.iterables.FuncIter$$Lambda$7;
import com.smaspe.iterables.FuncIter$$Lambda$8;
import com.smaspe.iterables.FuncIter$$Lambda$9;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FuncIter<T>
implements Iterable<T> {
    private static final Iterator EMPTY = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    };
    private Iterable<T> delegate;

    private FuncIter(Iterable<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public static <T> FuncIter<T> from(Iterable<T> delegate) {
        return new FuncIter<T>(delegate);
    }

    public static <T> FuncIter<T> iter(T ... array) {
        return FuncIter.from(FuncIter$$Lambda$1.lambdaFactory$(array));
    }

    public static <T> FuncIter<T> repeat(T value) {
        return FuncIter.from(FuncIter$$Lambda$4.lambdaFactory$(value));
    }

    public static <T> FuncIter<T> chain(Iterable<T> ... iterables) {
        return FuncIter.chain(FuncIter.iter(iterables));
    }

    public static <T> FuncIter<T> chain(Iterable<? extends Iterable<T>> iterables) {
        return FuncIter.from(FuncIter$$Lambda$5.lambdaFactory$(iterables));
    }

    public Iterable<T> chainWith(Iterable<T> next) {
        return FuncIter.chain(this, next);
    }

    public <R> FuncIter<R> map(Func<T, R> func) {
        return FuncIter.map(this, func);
    }

    public static <T, R> FuncIter<R> map(Iterable<T> input, Func<T, R> func) {
        return FuncIter.from(FuncIter$$Lambda$6.lambdaFactory$(input, func));
    }

    public FuncIter<T> filter(Func<T, Boolean> func) {
        return FuncIter.filter(this, func);
    }

    public static <T> FuncIter<T> filter(Iterable<T> input, Func<T, Boolean> func) {
        return FuncIter.from(FuncIter$$Lambda$7.lambdaFactory$(input, func));
    }

    public boolean all(Func<T, Boolean> test) {
        return FuncIter.all(this, test);
    }

    public static <T> boolean all(Iterable<T> input, Func<T, Boolean> test) {
        return !FuncIter.any(input, FuncIter$$Lambda$8.lambdaFactory$(test));
    }

    public boolean any(Func<T, Boolean> test) {
        return FuncIter.any(this, test);
    }

    public static <T> boolean any(Iterable<T> input, Func<T, Boolean> test) {
        for (T t : input) {
            if (!test.call(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public <V> FuncIter<Pair<T, V>> zip(Iterable<V> with) {
        return FuncIter.zip(this, with);
    }

    public static <U, V> FuncIter<Pair<U, V>> zip(Iterable<U> firsts, Iterable<V> seconds) {
        return FuncIter.from(FuncIter$$Lambda$9.lambdaFactory$(firsts, seconds));
    }

    public ArrayList<T> collect() {
        return FuncIter.collect(this);
    }

    public static <T> ArrayList<T> collect(Iterable<T> input) {
        ArrayList<T> res = new ArrayList<T>();
        for (T t : input) {
            res.add(t);
        }
        return res;
    }

    private static /* synthetic */ Iterator lambda$zip$6(final Iterable firsts, final Iterable seconds) {
        return new Iterator<Pair<U, V>>(){
            Iterator iterFirst;
            Iterator iterSecond;
            {
                this.iterFirst = firsts.iterator();
                this.iterSecond = seconds.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterFirst.hasNext() && this.iterSecond.hasNext();
            }

            @Override
            public Pair<U, V> next() {
                return new Pair(this.iterFirst.next(), this.iterSecond.next());
            }
        };
    }

    private static /* synthetic */ Boolean lambda$all$5(Func test, Object t) {
        return (Boolean)test.call(t) == false;
    }

    private static /* synthetic */ Iterator lambda$filter$4(final Iterable input, final Func func) {
        return new Iterator<T>(){
            boolean hasKnownNext = false;
            Iterator iter = input.iterator();
            Object nextValue = null;

            @Override
            public boolean hasNext() {
                if (this.hasKnownNext) {
                    return true;
                }
                while (this.iter.hasNext()) {
                    this.nextValue = this.iter.next();
                    if (!((Boolean)func.call(this.nextValue)).booleanValue()) continue;
                    this.hasKnownNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.hasKnownNext = false;
                    return this.nextValue;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private static /* synthetic */ Iterator lambda$map$3(final Iterable input, final Func func) {
        return new Iterator<R>(){
            Iterator iter;
            {
                this.iter = input.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public R next() {
                return func.call(this.iter.next());
            }
        };
    }

    private static /* synthetic */ Iterator lambda$chain$2(final Iterable iterables) {
        return new Iterator<T>(){
            Iterator iterator;
            Iterator current;
            {
                this.iterator = iterables.iterator();
                this.current = EMPTY;
            }

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.iterator.hasNext()) {
                    this.current = ((Iterable)this.iterator.next()).iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public T next() {
                this.hasNext();
                return this.current.next();
            }
        };
    }

    private static /* synthetic */ Iterator lambda$repeat$1(final Object value) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return value;
            }
        };
    }

    private static /* synthetic */ Iterator lambda$iter$0(final Object[] array) {
        return new Iterator<T>(){
            public int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public T next() {
                return array[this.i++];
            }
        };
    }

    static /* synthetic */ Iterator access$lambda$0(Object[] objectArray) {
        return FuncIter.lambda$iter$0(objectArray);
    }

    static /* synthetic */ Iterator access$lambda$1(Object object) {
        return FuncIter.lambda$repeat$1(object);
    }

    static /* synthetic */ Iterator access$lambda$2(Iterable iterable) {
        return FuncIter.lambda$chain$2(iterable);
    }

    static /* synthetic */ Iterator access$lambda$3(Iterable iterable, Func func) {
        return FuncIter.lambda$map$3(iterable, func);
    }

    static /* synthetic */ Iterator access$lambda$4(Iterable iterable, Func func) {
        return FuncIter.lambda$filter$4(iterable, func);
    }

    static /* synthetic */ Boolean access$lambda$5(Func func, Object object) {
        return FuncIter.lambda$all$5(func, object);
    }

    static /* synthetic */ Iterator access$lambda$6(Iterable iterable, Iterable iterable2) {
        return FuncIter.lambda$zip$6(iterable, iterable2);
    }

    public static class Pair<U, V> {
        public U first;
        public V second;

        private Pair(U first, V second) {
            this.first = first;
            this.second = second;
        }
    }

    public static interface Func<T, R> {
        public R call(T var1);
    }
}

