/*
 * Decompiled with CFR 0.152.
 */
package com.smaspe.iterables;

import com.smaspe.iterables.FuncIter$$Lambda$1;
import com.smaspe.iterables.FuncIter$$Lambda$10;
import com.smaspe.iterables.FuncIter$$Lambda$11;
import com.smaspe.iterables.FuncIter$$Lambda$4;
import com.smaspe.iterables.FuncIter$$Lambda$5;
import com.smaspe.iterables.FuncIter$$Lambda$6;
import com.smaspe.iterables.FuncIter$$Lambda$7;
import com.smaspe.iterables.FuncIter$$Lambda$8;
import com.smaspe.iterables.FuncIter$$Lambda$9;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FuncIter<T>
implements Iterable<T> {
    private static final Iterator EMPTY = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    };
    private Iterable<T> delegate;

    private FuncIter(Iterable<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public static <T> FuncIter<T> from(Iterable<T> delegate) {
        return new FuncIter<T>(delegate);
    }

    public static <T> FuncIter<T> iter(T ... array) {
        return FuncIter.from(FuncIter$$Lambda$1.lambdaFactory$(array));
    }

    public static <T> FuncIter<T> repeat(T value) {
        return FuncIter.from(FuncIter$$Lambda$4.lambdaFactory$(value));
    }

    public static FuncIter<Long> range(long end) {
        return FuncIter.range(0L, end);
    }

    public static FuncIter<Long> range(long start, long end) {
        return FuncIter.range(start, end, 1L);
    }

    public static FuncIter<Long> range(long start, long end, long step) {
        if (step == 0L) {
            throw new IllegalArgumentException("Step must not be 0");
        }
        return FuncIter.from(FuncIter$$Lambda$5.lambdaFactory$(start, end, step));
    }

    public <R> FuncIter<R> flatMap(Func<T, Iterable<R>> func) {
        return FuncIter.flatMap(this, func);
    }

    public static <T, R> FuncIter<R> flatMap(Iterable<T> iterables, Func<T, Iterable<R>> func) {
        return FuncIter.from(FuncIter$$Lambda$6.lambdaFactory$(iterables, func));
    }

    @SafeVarargs
    public static <T> FuncIter<T> chain(Iterable<T> ... iterables) {
        return FuncIter.flatMap(FuncIter.iter(iterables), FuncIter$$Lambda$7.lambdaFactory$());
    }

    public FuncIter<T> chainWith(Iterable<T> next) {
        return FuncIter.chain(this, next);
    }

    public <R> FuncIter<R> map(Func<T, R> func) {
        return FuncIter.map(this, func);
    }

    public static <T, R> FuncIter<R> map(Iterable<T> input, Func<T, R> func) {
        return FuncIter.from(FuncIter$$Lambda$8.lambdaFactory$(input, func));
    }

    public void each(Exec<T> func) {
        FuncIter.each(this, func);
    }

    public static <T> void each(Iterable<T> input, Exec<T> func) {
        for (T t : input) {
            func.call(t);
        }
    }

    public FuncIter<T> filter(Func<T, Boolean> func) {
        return FuncIter.filter(this, func);
    }

    public static <T> FuncIter<T> filter(Iterable<T> input, Func<T, Boolean> func) {
        return FuncIter.from(FuncIter$$Lambda$9.lambdaFactory$(input, func));
    }

    public boolean all(Func<T, Boolean> test) {
        return FuncIter.all(this, test);
    }

    public static <T> boolean all(Iterable<T> input, Func<T, Boolean> test) {
        return !FuncIter.any(input, FuncIter$$Lambda$10.lambdaFactory$(test));
    }

    public boolean any(Func<T, Boolean> test) {
        return FuncIter.any(this, test);
    }

    public static <T> boolean any(Iterable<T> input, Func<T, Boolean> test) {
        for (T t : input) {
            if (!test.call(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public T firstOr(T defaultValue) {
        return FuncIter.firstOr(this, defaultValue);
    }

    public static <T> T firstOr(Iterable<T> input, T defaultValue) {
        Iterator<T> iterator = input.iterator();
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public <V> FuncIter<Pair<T, V>> zip(Iterable<V> with) {
        return FuncIter.zip(this, with);
    }

    public static <U, V> FuncIter<Pair<U, V>> zip(Iterable<U> firsts, Iterable<V> seconds) {
        return FuncIter.from(FuncIter$$Lambda$11.lambdaFactory$(firsts, seconds));
    }

    public <R> R reduce(Func2<T, R, R> func, R accumulator) {
        return FuncIter.reduce(this, func, accumulator);
    }

    public static <T, R> R reduce(Iterable<T> input, Func2<T, R, R> func, R accumulator) {
        for (T value : input) {
            accumulator = func.call(value, accumulator);
        }
        return accumulator;
    }

    public FuncIter<Pair<Long, T>> enumerate() {
        return FuncIter.enumerate(this);
    }

    public static <T> FuncIter<Pair<Long, T>> enumerate(Iterable<T> input) {
        return FuncIter.zip(FuncIter.range(Long.MAX_VALUE), input);
    }

    public ArrayList<T> collect() {
        return FuncIter.collect(this);
    }

    public static <T> ArrayList<T> collect(Iterable<T> input) {
        ArrayList<T> res = new ArrayList<T>();
        for (T t : input) {
            res.add(t);
        }
        return res;
    }

    public <K> HashMap<K, T> collectWithKeys(Iterable<K> keys) {
        return FuncIter.collectWithKeys(this, keys);
    }

    public static <K, V> HashMap<K, V> collectWithKeys(Iterable<V> values, Iterable<K> keys) {
        HashMap res = new HashMap();
        for (Pair<K, V> t : FuncIter.from(keys).zip(values)) {
            res.put(t.first, t.second);
        }
        return res;
    }

    private static /* synthetic */ Iterator lambda$zip$8(final Iterable firsts, final Iterable seconds) {
        return new Iterator<Pair<U, V>>(){
            Iterator iterFirst;
            Iterator iterSecond;
            {
                this.iterFirst = firsts.iterator();
                this.iterSecond = seconds.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterFirst.hasNext() && this.iterSecond.hasNext();
            }

            @Override
            public Pair<U, V> next() {
                return new Pair(this.iterFirst.next(), this.iterSecond.next());
            }
        };
    }

    private static /* synthetic */ Boolean lambda$all$7(Func test, Object t) {
        return (Boolean)test.call(t) == false;
    }

    private static /* synthetic */ Iterator lambda$filter$6(final Iterable input, final Func func) {
        return new Iterator<T>(){
            boolean hasKnownNext = false;
            Iterator iter = input.iterator();
            Object nextValue = null;

            @Override
            public boolean hasNext() {
                if (this.hasKnownNext) {
                    return true;
                }
                while (this.iter.hasNext()) {
                    this.nextValue = this.iter.next();
                    if (!((Boolean)func.call(this.nextValue)).booleanValue()) continue;
                    this.hasKnownNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.hasKnownNext = false;
                    return this.nextValue;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private static /* synthetic */ Iterator lambda$map$5(final Iterable input, final Func func) {
        return new Iterator<R>(){
            Iterator iter;
            {
                this.iter = input.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public R next() {
                return func.call(this.iter.next());
            }
        };
    }

    private static /* synthetic */ Iterator lambda$flatMap$3(final Iterable iterables, final Func func) {
        return new Iterator<R>(){
            Iterator iterator;
            Iterator current;
            {
                this.iterator = iterables.iterator();
                this.current = EMPTY;
            }

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.iterator.hasNext()) {
                    this.current = ((Iterable)func.call(this.iterator.next())).iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public R next() {
                this.hasNext();
                return this.current.next();
            }
        };
    }

    private static /* synthetic */ Iterator lambda$range$2(final long start, final long end, final long step) {
        return new Iterator<Long>(){
            private long nextValue;
            {
                this.nextValue = start;
            }

            @Override
            public boolean hasNext() {
                return (end - this.nextValue) * step > 0L;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                long result = this.nextValue;
                this.nextValue += step;
                return result;
            }
        };
    }

    private static /* synthetic */ Iterator lambda$repeat$1(final Object value) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return value;
            }
        };
    }

    private static /* synthetic */ Iterator lambda$iter$0(final Object[] array) {
        return new Iterator<T>(){
            public int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public T next() {
                return array[this.i++];
            }
        };
    }

    static /* synthetic */ Iterator access$lambda$0(Object[] objectArray) {
        return FuncIter.lambda$iter$0(objectArray);
    }

    static /* synthetic */ Iterator access$lambda$1(Object object) {
        return FuncIter.lambda$repeat$1(object);
    }

    static /* synthetic */ Iterator access$lambda$2(long l, long l2, long l3) {
        return FuncIter.lambda$range$2(l, l2, l3);
    }

    static /* synthetic */ Iterator access$lambda$3(Iterable iterable, Func func) {
        return FuncIter.lambda$flatMap$3(iterable, func);
    }

    static /* synthetic */ Iterable access$lambda$4(Iterable iterable) {
        return iterable;
    }

    static /* synthetic */ Iterator access$lambda$5(Iterable iterable, Func func) {
        return FuncIter.lambda$map$5(iterable, func);
    }

    static /* synthetic */ Iterator access$lambda$6(Iterable iterable, Func func) {
        return FuncIter.lambda$filter$6(iterable, func);
    }

    static /* synthetic */ Boolean access$lambda$7(Func func, Object object) {
        return FuncIter.lambda$all$7(func, object);
    }

    static /* synthetic */ Iterator access$lambda$8(Iterable iterable, Iterable iterable2) {
        return FuncIter.lambda$zip$8(iterable, iterable2);
    }

    public static class Pair<U, V> {
        public U first;
        public V second;

        private Pair(U first, V second) {
            this.first = first;
            this.second = second;
        }
    }

    public static interface Exec<T> {
        public void call(T var1);
    }

    public static interface Func2<T1, T2, R> {
        public R call(T1 var1, T2 var2);
    }

    public static interface Func<T, R> {
        public R call(T var1);
    }
}

