/*
 * Decompiled with CFR 0.152.
 */
package ru.terrakok.cicerone;

import java.util.LinkedList;
import java.util.Queue;
import ru.terrakok.cicerone.Navigator;
import ru.terrakok.cicerone.NavigatorHolder;
import ru.terrakok.cicerone.commands.Command;

class CommandBuffer
implements NavigatorHolder {
    private Navigator navigator;
    private Queue<Command> pendingCommands = new LinkedList<Command>();

    CommandBuffer() {
    }

    @Override
    public void setNavigator(Navigator navigator) {
        this.navigator = navigator;
        while (!this.pendingCommands.isEmpty() && navigator != null) {
            this.executeCommand(this.pendingCommands.poll());
        }
    }

    @Override
    public void removeNavigator() {
        this.navigator = null;
    }

    public void executeCommand(Command command) {
        if (this.navigator != null) {
            this.navigator.applyCommand(command);
        } else {
            this.pendingCommands.add(command);
        }
    }
}

