/*
 * Decompiled with CFR 0.152.
 */
package ru.terrakok.cicerone;

import java.util.HashMap;
import ru.terrakok.cicerone.BaseRouter;
import ru.terrakok.cicerone.commands.Back;
import ru.terrakok.cicerone.commands.BackTo;
import ru.terrakok.cicerone.commands.Forward;
import ru.terrakok.cicerone.commands.Replace;
import ru.terrakok.cicerone.commands.SystemMessage;
import ru.terrakok.cicerone.result.ResultListener;

public class Router
extends BaseRouter {
    private HashMap<Integer, ResultListener> resultListeners = new HashMap();

    public void setResultListener(Integer resultCode, ResultListener listener) {
        this.resultListeners.put(resultCode, listener);
    }

    public void removeResultListener(Integer resultCode) {
        this.resultListeners.remove(resultCode);
    }

    protected boolean sendResult(Integer resultCode, Object result) {
        ResultListener resultListener = this.resultListeners.get(resultCode);
        if (resultListener != null) {
            resultListener.onResult(result);
            return true;
        }
        return false;
    }

    public void navigateTo(String screenKey) {
        this.navigateTo(screenKey, null);
    }

    public void navigateTo(String screenKey, Object data) {
        this.executeCommand(new Forward(screenKey, data));
    }

    public void newScreenChain(String screenKey) {
        this.newScreenChain(screenKey, null);
    }

    public void newScreenChain(String screenKey, Object data) {
        this.executeCommand(new BackTo(null));
        this.executeCommand(new Forward(screenKey, data));
    }

    public void newRootScreen(String screenKey) {
        this.newRootScreen(screenKey, null);
    }

    public void newRootScreen(String screenKey, Object data) {
        this.executeCommand(new BackTo(null));
        this.executeCommand(new Replace(screenKey, data));
    }

    public void replaceScreen(String screenKey) {
        this.replaceScreen(screenKey, null);
    }

    public void replaceScreen(String screenKey, Object data) {
        this.executeCommand(new Replace(screenKey, data));
    }

    public void backTo(String screenKey) {
        this.executeCommand(new BackTo(screenKey));
    }

    public void finishChain() {
        this.executeCommand(new BackTo(null));
        this.executeCommand(new Back());
    }

    public void exit() {
        this.executeCommand(new Back());
    }

    public void exitWithResult(Integer resultCode, Object result) {
        this.exit();
        this.sendResult(resultCode, result);
    }

    public void exitWithMessage(String message) {
        this.executeCommand(new Back());
        this.executeCommand(new SystemMessage(message));
    }

    public void showSystemMessage(String message) {
        this.executeCommand(new SystemMessage(message));
    }
}

