/*
 * Decompiled with CFR 0.152.
 */
package ru.terrakok.cicerone.android;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import ru.terrakok.cicerone.Navigator;
import ru.terrakok.cicerone.commands.Back;
import ru.terrakok.cicerone.commands.BackTo;
import ru.terrakok.cicerone.commands.Command;
import ru.terrakok.cicerone.commands.Forward;
import ru.terrakok.cicerone.commands.Replace;
import ru.terrakok.cicerone.commands.SystemMessage;

public abstract class FragmentNavigator
implements Navigator {
    private FragmentManager fragmentManager;
    private int containerId;

    public FragmentNavigator(FragmentManager fragmentManager, int containerId) {
        this.fragmentManager = fragmentManager;
        this.containerId = containerId;
    }

    protected void setupFragmentTransactionAnimation(Command command, Fragment currentFragment, Fragment nextFragment, FragmentTransaction fragmentTransaction) {
    }

    @Override
    public void applyCommand(Command command) {
        if (command instanceof Forward) {
            Forward forward = (Forward)command;
            Fragment fragment = this.createFragment(forward.getScreenKey(), forward.getTransitionData());
            if (fragment == null) {
                this.unknownScreen(command);
                return;
            }
            FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
            this.setupFragmentTransactionAnimation(command, this.fragmentManager.findFragmentById(this.containerId), fragment, fragmentTransaction);
            fragmentTransaction.replace(this.containerId, fragment).addToBackStack(forward.getScreenKey()).commit();
        } else if (command instanceof Back) {
            if (this.fragmentManager.getBackStackEntryCount() > 0) {
                this.fragmentManager.popBackStackImmediate();
            } else {
                this.exit();
            }
        } else if (command instanceof Replace) {
            Replace replace = (Replace)command;
            Fragment fragment = this.createFragment(replace.getScreenKey(), replace.getTransitionData());
            if (fragment == null) {
                this.unknownScreen(command);
                return;
            }
            if (this.fragmentManager.getBackStackEntryCount() > 0) {
                this.fragmentManager.popBackStackImmediate();
                FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
                this.setupFragmentTransactionAnimation(command, this.fragmentManager.findFragmentById(this.containerId), fragment, fragmentTransaction);
                fragmentTransaction.replace(this.containerId, fragment).addToBackStack(replace.getScreenKey()).commit();
            } else {
                FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
                this.setupFragmentTransactionAnimation(command, this.fragmentManager.findFragmentById(this.containerId), fragment, fragmentTransaction);
                fragmentTransaction.replace(this.containerId, fragment).commit();
            }
        } else if (command instanceof BackTo) {
            String key = ((BackTo)command).getScreenKey();
            if (key == null) {
                this.backToRoot();
            } else {
                boolean hasScreen = false;
                for (int i = 0; i < this.fragmentManager.getBackStackEntryCount(); ++i) {
                    if (!key.equals(this.fragmentManager.getBackStackEntryAt(i).getName())) continue;
                    this.fragmentManager.popBackStackImmediate(key, 0);
                    hasScreen = true;
                    break;
                }
                if (!hasScreen) {
                    this.backToUnexisting();
                }
            }
        } else if (command instanceof SystemMessage) {
            this.showSystemMessage(((SystemMessage)command).getMessage());
        }
    }

    private void backToRoot() {
        this.fragmentManager.popBackStackImmediate(null, 1);
    }

    protected abstract Fragment createFragment(String var1, Object var2);

    protected abstract void showSystemMessage(String var1);

    protected abstract void exit();

    protected void backToUnexisting() {
        this.backToRoot();
    }

    protected void unknownScreen(Command command) {
        throw new RuntimeException("Can't create a screen for passed screenKey.");
    }
}

