/*
 * Decompiled with CFR 0.152.
 */
package konveyor.generate;

import com.github.vacxe.konveyor.generate.EnumGenerator;
import com.github.vacxe.konveyor.generate.ImmutableCollectionGenerator;
import com.github.vacxe.konveyor.generate.InterfaceGenerator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import konveyor.exceptions.KonveyorException;
import konveyor.generate.ObjectResolver;
import konveyor.generate.PrimitiveGenerator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J3\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\u00012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0006H\u0002J\u001c\u0010\u0017\u001a\u00020\u00012\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J'\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkonveyor/generate/Generator;", "", "objectResolver", "Lkonveyor/generate/ObjectResolver;", "(Lkonveyor/generate/ObjectResolver;)V", "MAX_NESTING", "", "enumGenerator", "Lcom/github/vacxe/konveyor/generate/EnumGenerator;", "interfaceGenerator", "Lcom/github/vacxe/konveyor/generate/InterfaceGenerator;", "randomCollectionsGenerator", "Lcom/github/vacxe/konveyor/generate/ImmutableCollectionGenerator;", "randomPrimitiveGenerator", "Lkonveyor/generate/PrimitiveGenerator;", "build", "T", "clazz", "Ljava/lang/Class;", "constructorNumber", "nestedLevel", "(Ljava/lang/Class;II)Ljava/lang/Object;", "generateNestedClass", "getRandomValue", "parameterType", "initConstructorArguments", "", "constructor", "Ljava/lang/reflect/Constructor;", "(Ljava/lang/reflect/Constructor;I)[Ljava/lang/Object;", "Konveyor"})
public final class Generator {
    private final int MAX_NESTING = 100;
    private final PrimitiveGenerator randomPrimitiveGenerator;
    private final ImmutableCollectionGenerator randomCollectionsGenerator;
    private final EnumGenerator enumGenerator;
    private final InterfaceGenerator interfaceGenerator;
    private final ObjectResolver objectResolver;

    public final <T> T build(@NotNull Class<T> clazz, int constructorNumber, int nestedLevel) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        if (nestedLevel > this.MAX_NESTING) {
            throw (Throwable)new KonveyorException("Generation level out of possible nesting");
        }
        Object[] constructors = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(constructors, (String)"constructors");
        Object[] $receiver$iv = constructors;
        if ($receiver$iv.length > 1) {
            objectArray = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Constructor it;
                    Constructor constructor = it = (Constructor)a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)constructor, (String)"it");
                    it = (Constructor)b;
                    Comparable comparable = Integer.valueOf(constructor.getParameterCount());
                    Constructor constructor2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)constructor2, (String)"it");
                    Integer n = constructor2.getParameterCount();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            };
            ArraysKt.sortWith((Object[])objectArray, (Comparator)comparator);
        }
        objectArray = $receiver$iv = constructors;
        if (!(objectArray.length == 0)) {
            int n = constructors.length;
            for (int i = 0; i < n; ++i) {
                Object constructor = constructors[i];
                try {
                    Object constructor2;
                    Object object = constructor2 = constructors[constructorNumber];
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"constructor");
                    Object[] constructorArguments = this.initConstructorArguments((Constructor<?>)object, nestedLevel);
                    return ((Constructor)constructor2).newInstance(Arrays.copyOf(constructorArguments, constructorArguments.length));
                }
                catch (Exception e) {
                    System.out.print(e.getMessage());
                    continue;
                }
            }
            throw (Throwable)new KonveyorException("Impossible to create " + clazz);
        }
        throw (Throwable)new KonveyorException("" + clazz + " doesn't contain public constructors");
    }

    public static /* bridge */ /* synthetic */ Object build$default(Generator generator, Class clazz, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return generator.build(clazz, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] initConstructorArguments(Constructor<?> constructor, int nestedLevel) {
        int size$iv = constructor.getParameterCount();
        Object[] result$iv22 = new Object[size$iv];
        int n = 0;
        int n2 = result$iv22.length;
        while (n < n2) {
            void it;
            void i$iv;
            void var8_9 = i$iv;
            void var12_11 = i$iv++;
            Object[] objectArray = result$iv22;
            Integer n3 = (int)(it + true);
            objectArray[var12_11] = n3;
        }
        Object[] constructorArguments = result$iv22;
        Parameter[] constructorParameters = constructor.getParameters();
        int result$iv22 = 0;
        Intrinsics.checkExpressionValueIsNotNull((Object)constructorParameters, (String)"constructorParameters");
        n = constructorParameters.length;
        while (result$iv22 < n) {
            void index;
            Parameter parameter = constructorParameters[index];
            Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"constructorParameters[index]");
            Class<?> clazz = parameter.getType();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"constructorParameters[index].type");
            constructorArguments[index] = this.getRandomValue(clazz, nestedLevel);
            ++index;
        }
        return constructorArguments;
    }

    private final Object getRandomValue(Class<?> parameterType, int nestedLevel) {
        Object object = this.randomPrimitiveGenerator.isPrimitive(parameterType) ? this.randomPrimitiveGenerator.generatePrimitive(parameterType) : (this.randomCollectionsGenerator.isImmutableCollection(parameterType) ? this.randomCollectionsGenerator.generateCollection(parameterType) : (this.enumGenerator.isEnum(parameterType) ? this.enumGenerator.generateEnum(parameterType) : (this.interfaceGenerator.isInterface(parameterType) ? this.interfaceGenerator.generateMock(parameterType) : this.generateNestedClass(parameterType, nestedLevel + 1))));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"when {\n                r\u2026dLevel + 1)\n            }");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Object generateNestedClass(Class<?> clazz, int nestedLevel) {
        Object object = this.objectResolver.resolve$Konveyor(clazz);
        if (object != null) {
            Object object2;
            Object it = object2 = object;
            return it;
        }
        int n = 0;
        int n2 = clazz.getConstructors().length;
        if (n <= n2) {
            while (true) {
                void constructorNumber;
                try {
                    Object obj = this.build(clazz, (int)constructorNumber, nestedLevel);
                    Intrinsics.checkExpressionValueIsNotNull(obj, (String)"build(clazz, constructor\u2026estedLevel = nestedLevel)");
                    return obj;
                }
                catch (KonveyorException konveyorException) {
                    if (constructorNumber == n2) break;
                    ++constructorNumber;
                    continue;
                }
                break;
            }
        }
        throw (Throwable)new KonveyorException("No possible to create constructor build tree");
    }

    static /* bridge */ /* synthetic */ Object generateNestedClass$default(Generator generator, Class clazz, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return generator.generateNestedClass(clazz, n);
    }

    public Generator(@NotNull ObjectResolver objectResolver) {
        Intrinsics.checkParameterIsNotNull((Object)objectResolver, (String)"objectResolver");
        this.objectResolver = objectResolver;
        this.MAX_NESTING = 100;
        this.randomPrimitiveGenerator = new PrimitiveGenerator();
        this.randomCollectionsGenerator = new ImmutableCollectionGenerator();
        this.enumGenerator = new EnumGenerator();
        this.interfaceGenerator = new InterfaceGenerator();
    }

    public /* synthetic */ Generator(ObjectResolver objectResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            objectResolver = new ObjectResolver();
        }
        this(objectResolver);
    }

    public Generator() {
        this(null, 1, null);
    }
}

