/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.structure.Row;

public class RepeatedHeaderTableDrawer
extends TableDrawer {
    private int numberOfRowsToRepeat;
    private Float headerHeight;

    @Override
    protected void drawPage(TableDrawer.PageData pageData) {
        if (pageData.firstRowOnPage != 0) {
            float adaption = 0.0f;
            for (int i = 0; i < this.numberOfRowsToRepeat; ++i) {
                Point2D.Float startPoint = new Point2D.Float(this.startX, this.startY + this.calculateHeightForFirstRows() - (adaption += this.table.getRows().get(i).getHeight()));
                this.drawRow(startPoint, this.table.getRows().get(i), i, (drawer, drawingContext) -> {
                    drawer.drawBackground((DrawingContext)drawingContext);
                    drawer.drawContent((DrawingContext)drawingContext);
                    drawer.drawBorders((DrawingContext)drawingContext);
                });
            }
        }
        this.drawerList.forEach(drawer -> this.drawWithFunction(pageData, new Point2D.Float(this.startX, this.startY), (BiConsumer<Drawer, DrawingContext>)drawer));
    }

    @Override
    protected void determinePageToStartTable(float yOffsetOnNewPage) {
        float minimumRowsToFitHeight = 0.0f;
        int minimumRowsToFit = this.table.getRows().size() > this.numberOfRowsToRepeat ? this.numberOfRowsToRepeat + 1 : this.numberOfRowsToRepeat;
        for (Row row : this.table.getRows().subList(0, minimumRowsToFit)) {
            minimumRowsToFitHeight += row.getHeight();
        }
        if (this.startY - minimumRowsToFitHeight < this.endY) {
            this.startY = yOffsetOnNewPage + this.calculateHeightForFirstRows();
            this.startTableInNewPage = true;
        }
    }

    @Override
    public void draw(Supplier<PDDocument> documentSupplier, Supplier<PDPage> pageSupplier, float yOffset) throws IOException {
        super.draw(documentSupplier, pageSupplier, yOffset + this.calculateHeightForFirstRows());
    }

    private float calculateHeightForFirstRows() {
        if (this.headerHeight != null) {
            return this.headerHeight.floatValue();
        }
        float height = 0.0f;
        for (int i = 0; i < this.numberOfRowsToRepeat; ++i) {
            height += this.table.getRows().get(i).getHeight();
        }
        this.headerHeight = Float.valueOf(height);
        return height;
    }

    private static int $default$numberOfRowsToRepeat() {
        return 1;
    }

    protected RepeatedHeaderTableDrawer(RepeatedHeaderTableDrawerBuilder<?, ?> b) {
        super(b);
        this.numberOfRowsToRepeat = b.numberOfRowsToRepeat$set ? b.numberOfRowsToRepeat$value : RepeatedHeaderTableDrawer.$default$numberOfRowsToRepeat();
        this.headerHeight = b.headerHeight;
    }

    public static RepeatedHeaderTableDrawerBuilder<?, ?> builder() {
        return new RepeatedHeaderTableDrawerBuilderImpl();
    }

    private static final class RepeatedHeaderTableDrawerBuilderImpl
    extends RepeatedHeaderTableDrawerBuilder<RepeatedHeaderTableDrawer, RepeatedHeaderTableDrawerBuilderImpl> {
        private RepeatedHeaderTableDrawerBuilderImpl() {
        }

        @Override
        protected RepeatedHeaderTableDrawerBuilderImpl self() {
            return this;
        }

        @Override
        public RepeatedHeaderTableDrawer build() {
            return new RepeatedHeaderTableDrawer(this);
        }
    }

    public static abstract class RepeatedHeaderTableDrawerBuilder<C extends RepeatedHeaderTableDrawer, B extends RepeatedHeaderTableDrawerBuilder<C, B>>
    extends TableDrawer.TableDrawerBuilder<C, B> {
        private boolean numberOfRowsToRepeat$set;
        private int numberOfRowsToRepeat$value;
        private Float headerHeight;

        public B numberOfRowsToRepeat(int numberOfRowsToRepeat) {
            this.numberOfRowsToRepeat$value = numberOfRowsToRepeat;
            this.numberOfRowsToRepeat$set = true;
            return (B)this.self();
        }

        public B headerHeight(Float headerHeight) {
            this.headerHeight = headerHeight;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "RepeatedHeaderTableDrawer.RepeatedHeaderTableDrawerBuilder(super=" + super.toString() + ", numberOfRowsToRepeat$value=" + this.numberOfRowsToRepeat$value + ", headerHeight=" + this.headerHeight + ")";
        }
    }
}

