/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing.cell;

import java.awt.geom.Point2D;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.cell.AbstractCellDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.cell.ImageCell;

public class ImageCellDrawer
extends AbstractCellDrawer<ImageCell> {
    public ImageCellDrawer(ImageCell cell) {
        this.cell = cell;
    }

    @Override
    public void drawContent(DrawingContext drawingContext) {
        PDPageContentStream contentStream = drawingContext.getContentStream();
        float moveX = drawingContext.getStartingPoint().x;
        Point2D.Float size = ((ImageCell)this.cell).getFitSize();
        Point2D.Float drawAt = new Point2D.Float();
        float xOffset = moveX + ((ImageCell)this.cell).getPaddingLeft();
        if (((ImageCell)this.cell).getSettings().getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
            xOffset = moveX + (((ImageCell)this.cell).getWidth() - (size.x + ((ImageCell)this.cell).getPaddingRight()));
        } else if (((ImageCell)this.cell).getSettings().getHorizontalAlignment() == HorizontalAlignment.CENTER) {
            float diff = (((ImageCell)this.cell).getWidth() - size.x) / 2.0f;
            xOffset = moveX + diff;
        }
        drawAt.x = xOffset;
        drawAt.y = drawingContext.getStartingPoint().y + this.getAdaptionForVerticalAlignment() - size.y;
        contentStream.drawImage(((ImageCell)this.cell).getImage(), drawAt.x, drawAt.y, size.x, size.y);
    }

    @Override
    protected float calculateInnerHeight() {
        return (float)((ImageCell)this.cell).getFitSize().getY();
    }

    public ImageCellDrawer() {
    }
}

