/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.structure.Row;

public class OverflowOnSamePageRepeatableHeaderTableDrawer
extends TableDrawer {
    private final int lanesPerPage;
    private final float spaceInBetween;
    private int numberOfRowsToRepeat;
    private Float headerHeight;
    private int actualTableLane;

    @Override
    protected void drawPage(TableDrawer.PageData pageData) {
        if (pageData.firstRowOnPage != 0) {
            this.drawHeaderForCurrentLane();
        }
        this.drawerList.forEach(drawer -> this.drawWithFunction(pageData, new Point2D.Float(this.startX + this.calculateXOffset(), this.startY), (BiConsumer<Drawer, DrawingContext>)drawer));
    }

    private float calculateXOffset() {
        float widthOfTableLanes = (float)(this.actualTableLane - 1) * this.table.getWidth();
        float spacing = this.actualTableLane > 1 ? (float)(this.actualTableLane - 1) * this.spaceInBetween : 0.0f;
        return widthOfTableLanes + spacing;
    }

    private float calculateHeightForFirstRows() {
        if (this.headerHeight != null) {
            return this.headerHeight.floatValue();
        }
        float height = 0.0f;
        for (int i = 0; i < this.numberOfRowsToRepeat; ++i) {
            height += this.table.getRows().get(i).getHeight();
        }
        this.headerHeight = Float.valueOf(height);
        return height;
    }

    @Override
    protected void determinePageToStartTable(float yOffsetOnNewPage) {
        float minimumRowsToFitHeight = 0.0f;
        int minimumRowsToFit = this.table.getRows().size() > this.numberOfRowsToRepeat ? this.numberOfRowsToRepeat + 1 : this.numberOfRowsToRepeat;
        for (Row row : this.table.getRows().subList(0, minimumRowsToFit)) {
            minimumRowsToFitHeight += row.getHeight();
        }
        if (this.startY - minimumRowsToFitHeight < this.endY) {
            this.startY = yOffsetOnNewPage + this.calculateHeightForFirstRows();
            this.startTableInNewPage = true;
        }
    }

    public void drawHeaderForCurrentLane() {
        float adaption = 0.0f;
        for (int k = 0; k < this.numberOfRowsToRepeat; ++k) {
            Point2D.Float startPoint = new Point2D.Float(this.startX + this.calculateXOffset(), this.startY + this.calculateHeightForFirstRows() - (adaption += this.table.getRows().get(k).getHeight()));
            this.drawRow(startPoint, this.table.getRows().get(k), k, (drawer, drawingContext) -> {
                drawer.drawBackground((DrawingContext)drawingContext);
                drawer.drawContent((DrawingContext)drawingContext);
                drawer.drawBorders((DrawingContext)drawingContext);
            });
        }
    }

    @Override
    public void draw(Supplier<PDDocument> documentSupplier, Supplier<PDPage> pageSupplier, float yOffset) throws IOException {
        PDDocument document = documentSupplier.get();
        float startOnNewPage = pageSupplier.get().getMediaBox().getHeight() - yOffset;
        this.determinePageToStartTable(startOnNewPage);
        Queue<TableDrawer.PageData> pageDataQueue = this.computeRowsOnPagesWithNewPageStartOf(startOnNewPage);
        int i = 0;
        while (!pageDataQueue.isEmpty()) {
            PDPage pageToDrawOn = this.determinePageToDraw(i, document, pageSupplier);
            if (i == 0 && this.startTableInNewPage || i > 0 || document.getNumberOfPages() == 0 || this.actualTableLane != this.lanesPerPage) {
                this.startTableInNewPage = false;
            }
            if (i == 0) {
                this.tableStartPage = pageToDrawOn;
            }
            try (PDPageContentStream newPageContentStream = new PDPageContentStream(document, pageToDrawOn, PDPageContentStream.AppendMode.APPEND, this.compress);){
                for (int j = 1; j <= this.lanesPerPage && !pageDataQueue.isEmpty(); ++j) {
                    this.actualTableLane = j;
                    if (this.actualTableLane > 1) {
                        this.startY = startOnNewPage;
                    }
                    this.contentStream(newPageContentStream).page(pageToDrawOn).drawPage(pageDataQueue.poll());
                }
            }
            this.startY(pageToDrawOn.getMediaBox().getHeight() - yOffset);
            ++i;
        }
    }

    private static int $default$lanesPerPage() {
        return 2;
    }

    private static float $default$spaceInBetween() {
        return 10.0f;
    }

    private static int $default$numberOfRowsToRepeat() {
        return 1;
    }

    private static int $default$actualTableLane() {
        return 1;
    }

    protected OverflowOnSamePageRepeatableHeaderTableDrawer(OverflowOnSamePageRepeatableHeaderTableDrawerBuilder<?, ?> b) {
        super(b);
        this.lanesPerPage = b.lanesPerPage$set ? b.lanesPerPage$value : OverflowOnSamePageRepeatableHeaderTableDrawer.$default$lanesPerPage();
        this.spaceInBetween = b.spaceInBetween$set ? b.spaceInBetween$value : OverflowOnSamePageRepeatableHeaderTableDrawer.$default$spaceInBetween();
        this.numberOfRowsToRepeat = b.numberOfRowsToRepeat$set ? b.numberOfRowsToRepeat$value : OverflowOnSamePageRepeatableHeaderTableDrawer.$default$numberOfRowsToRepeat();
        this.headerHeight = b.headerHeight;
        this.actualTableLane = b.actualTableLane$set ? b.actualTableLane$value : OverflowOnSamePageRepeatableHeaderTableDrawer.$default$actualTableLane();
    }

    public static OverflowOnSamePageRepeatableHeaderTableDrawerBuilder<?, ?> builder() {
        return new OverflowOnSamePageRepeatableHeaderTableDrawerBuilderImpl();
    }

    public OverflowOnSamePageRepeatableHeaderTableDrawerBuilder<?, ?> toBuilder() {
        return new OverflowOnSamePageRepeatableHeaderTableDrawerBuilderImpl().$fillValuesFrom(this);
    }

    private static final class OverflowOnSamePageRepeatableHeaderTableDrawerBuilderImpl
    extends OverflowOnSamePageRepeatableHeaderTableDrawerBuilder<OverflowOnSamePageRepeatableHeaderTableDrawer, OverflowOnSamePageRepeatableHeaderTableDrawerBuilderImpl> {
        private OverflowOnSamePageRepeatableHeaderTableDrawerBuilderImpl() {
        }

        @Override
        protected OverflowOnSamePageRepeatableHeaderTableDrawerBuilderImpl self() {
            return this;
        }

        @Override
        public OverflowOnSamePageRepeatableHeaderTableDrawer build() {
            return new OverflowOnSamePageRepeatableHeaderTableDrawer(this);
        }
    }

    public static abstract class OverflowOnSamePageRepeatableHeaderTableDrawerBuilder<C extends OverflowOnSamePageRepeatableHeaderTableDrawer, B extends OverflowOnSamePageRepeatableHeaderTableDrawerBuilder<C, B>>
    extends TableDrawer.TableDrawerBuilder<C, B> {
        private boolean lanesPerPage$set;
        private int lanesPerPage$value;
        private boolean spaceInBetween$set;
        private float spaceInBetween$value;
        private boolean numberOfRowsToRepeat$set;
        private int numberOfRowsToRepeat$value;
        private Float headerHeight;
        private boolean actualTableLane$set;
        private int actualTableLane$value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            OverflowOnSamePageRepeatableHeaderTableDrawerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(OverflowOnSamePageRepeatableHeaderTableDrawer instance, OverflowOnSamePageRepeatableHeaderTableDrawerBuilder<?, ?> b) {
            b.lanesPerPage(instance.lanesPerPage);
            b.spaceInBetween(instance.spaceInBetween);
            b.numberOfRowsToRepeat(instance.numberOfRowsToRepeat);
            b.headerHeight(instance.headerHeight);
            b.actualTableLane(instance.actualTableLane);
        }

        public B lanesPerPage(int lanesPerPage) {
            this.lanesPerPage$value = lanesPerPage;
            this.lanesPerPage$set = true;
            return (B)this.self();
        }

        public B spaceInBetween(float spaceInBetween) {
            this.spaceInBetween$value = spaceInBetween;
            this.spaceInBetween$set = true;
            return (B)this.self();
        }

        public B numberOfRowsToRepeat(int numberOfRowsToRepeat) {
            this.numberOfRowsToRepeat$value = numberOfRowsToRepeat;
            this.numberOfRowsToRepeat$set = true;
            return (B)this.self();
        }

        public B headerHeight(Float headerHeight) {
            this.headerHeight = headerHeight;
            return (B)this.self();
        }

        public B actualTableLane(int actualTableLane) {
            this.actualTableLane$value = actualTableLane;
            this.actualTableLane$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "OverflowOnSamePageRepeatableHeaderTableDrawer.OverflowOnSamePageRepeatableHeaderTableDrawerBuilder(super=" + super.toString() + ", lanesPerPage$value=" + this.lanesPerPage$value + ", spaceInBetween$value=" + this.spaceInBetween$value + ", numberOfRowsToRepeat$value=" + this.numberOfRowsToRepeat$value + ", headerHeight=" + this.headerHeight + ", actualTableLane$value=" + this.actualTableLane$value + ")";
        }
    }
}

