/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;

public class OverflowOnSamePageTableDrawer
extends TableDrawer {
    private final int lanesPerPage;
    private final float spaceInBetween;
    private int actualTableLane;

    @Override
    protected void drawPage(TableDrawer.PageData pageData) {
        this.drawerList.forEach(drawer -> this.drawWithFunction(pageData, new Point2D.Float(this.startX + this.calculateXOffset(), this.startY), (BiConsumer<Drawer, DrawingContext>)drawer));
    }

    private float calculateXOffset() {
        float widthOfTableLanes = (float)(this.actualTableLane - 1) * this.table.getWidth();
        float spacing = this.actualTableLane > 1 ? (float)(this.actualTableLane - 1) * this.spaceInBetween : 0.0f;
        return widthOfTableLanes + spacing;
    }

    @Override
    public void draw(Supplier<PDDocument> documentSupplier, Supplier<PDPage> pageSupplier, float yOffset) throws IOException {
        PDDocument document = documentSupplier.get();
        float startOnNewPage = pageSupplier.get().getMediaBox().getHeight() - yOffset;
        this.determinePageToStartTable(startOnNewPage);
        Queue<TableDrawer.PageData> pageDataQueue = this.computeRowsOnPagesWithNewPageStartOf(startOnNewPage);
        int i = 0;
        while (!pageDataQueue.isEmpty()) {
            PDPage pageToDrawOn = this.determinePageToDraw(i, document, pageSupplier);
            if (i == 0 && this.startTableInNewPage || i > 0 || document.getNumberOfPages() == 0 || this.actualTableLane != this.lanesPerPage) {
                this.startTableInNewPage = false;
            }
            if (i == 0) {
                this.tableStartPage = pageToDrawOn;
            }
            try (PDPageContentStream newPageContentStream = new PDPageContentStream(document, pageToDrawOn, PDPageContentStream.AppendMode.APPEND, this.compress);){
                for (int j = 1; j <= this.lanesPerPage && !pageDataQueue.isEmpty(); ++j) {
                    this.actualTableLane = j;
                    if (this.actualTableLane > 1) {
                        this.startY = startOnNewPage;
                    }
                    this.contentStream(newPageContentStream).page(pageToDrawOn).drawPage(pageDataQueue.poll());
                }
            }
            this.startY(pageToDrawOn.getMediaBox().getHeight() - yOffset);
            ++i;
        }
    }

    private static int $default$lanesPerPage() {
        return 2;
    }

    private static float $default$spaceInBetween() {
        return 10.0f;
    }

    private static int $default$actualTableLane() {
        return 1;
    }

    protected OverflowOnSamePageTableDrawer(OverflowOnSamePageTableDrawerBuilder<?, ?> b) {
        super(b);
        this.lanesPerPage = b.lanesPerPage$set ? b.lanesPerPage$value : OverflowOnSamePageTableDrawer.$default$lanesPerPage();
        this.spaceInBetween = b.spaceInBetween$set ? b.spaceInBetween$value : OverflowOnSamePageTableDrawer.$default$spaceInBetween();
        this.actualTableLane = b.actualTableLane$set ? b.actualTableLane$value : OverflowOnSamePageTableDrawer.$default$actualTableLane();
    }

    public static OverflowOnSamePageTableDrawerBuilder<?, ?> builder() {
        return new OverflowOnSamePageTableDrawerBuilderImpl();
    }

    public OverflowOnSamePageTableDrawerBuilder<?, ?> toBuilder() {
        return new OverflowOnSamePageTableDrawerBuilderImpl().$fillValuesFrom(this);
    }

    private static final class OverflowOnSamePageTableDrawerBuilderImpl
    extends OverflowOnSamePageTableDrawerBuilder<OverflowOnSamePageTableDrawer, OverflowOnSamePageTableDrawerBuilderImpl> {
        private OverflowOnSamePageTableDrawerBuilderImpl() {
        }

        @Override
        protected OverflowOnSamePageTableDrawerBuilderImpl self() {
            return this;
        }

        @Override
        public OverflowOnSamePageTableDrawer build() {
            return new OverflowOnSamePageTableDrawer(this);
        }
    }

    public static abstract class OverflowOnSamePageTableDrawerBuilder<C extends OverflowOnSamePageTableDrawer, B extends OverflowOnSamePageTableDrawerBuilder<C, B>>
    extends TableDrawer.TableDrawerBuilder<C, B> {
        private boolean lanesPerPage$set;
        private int lanesPerPage$value;
        private boolean spaceInBetween$set;
        private float spaceInBetween$value;
        private boolean actualTableLane$set;
        private int actualTableLane$value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            OverflowOnSamePageTableDrawerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(OverflowOnSamePageTableDrawer instance, OverflowOnSamePageTableDrawerBuilder<?, ?> b) {
            b.lanesPerPage(instance.lanesPerPage);
            b.spaceInBetween(instance.spaceInBetween);
            b.actualTableLane(instance.actualTableLane);
        }

        public B lanesPerPage(int lanesPerPage) {
            this.lanesPerPage$value = lanesPerPage;
            this.lanesPerPage$set = true;
            return (B)this.self();
        }

        public B spaceInBetween(float spaceInBetween) {
            this.spaceInBetween$value = spaceInBetween;
            this.spaceInBetween$set = true;
            return (B)this.self();
        }

        public B actualTableLane(int actualTableLane) {
            this.actualTableLane$value = actualTableLane;
            this.actualTableLane$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "OverflowOnSamePageTableDrawer.OverflowOnSamePageTableDrawerBuilder(super=" + super.toString() + ", lanesPerPage$value=" + this.lanesPerPage$value + ", spaceInBetween$value=" + this.spaceInBetween$value + ", actualTableLane$value=" + this.actualTableLane$value + ")";
        }
    }
}

