/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.AbstractBuffer;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;

public class BarBuffer
extends AbstractBuffer<IBarDataSet> {
    protected int mDataSetIndex = 0;
    protected int mDataSetCount = 1;
    protected boolean mContainsStacks = false;
    protected boolean mInverted = false;
    protected float mBarWidth = 1.0f;

    public BarBuffer(int size, int dataSetCount, boolean containsStacks) {
        super(size);
        this.mDataSetCount = dataSetCount;
        this.mContainsStacks = containsStacks;
    }

    public void setBarWidth(float barWidth) {
        this.mBarWidth = barWidth;
    }

    public void setDataSet(int index) {
        this.mDataSetIndex = index;
    }

    public void setInverted(boolean inverted) {
        this.mInverted = inverted;
    }

    protected void addBar(float left, float top, float right, float bottom) {
        this.buffer[this.index++] = left;
        this.buffer[this.index++] = top;
        this.buffer[this.index++] = right;
        this.buffer[this.index++] = bottom;
    }

    @Override
    public void feed(IBarDataSet data) {
        float size = (float)data.getEntryCount() * this.phaseX;
        float barWidthHalf = this.mBarWidth / 2.0f;
        int i = 0;
        while ((float)i < size) {
            BarEntry e = (BarEntry)data.getEntryForIndex(i);
            if (e != null) {
                float x = e.getX();
                float y = e.getY();
                float[] vals = e.getYVals();
                if (!this.mContainsStacks || vals == null) {
                    float top;
                    float bottom;
                    float left = x - barWidthHalf;
                    float right = x + barWidthHalf;
                    if (this.mInverted) {
                        bottom = y >= 0.0f ? y : 0.0f;
                        top = y <= 0.0f ? y : 0.0f;
                    } else {
                        top = y >= 0.0f ? y : 0.0f;
                        float f = bottom = y <= 0.0f ? y : 0.0f;
                    }
                    if (top > 0.0f) {
                        top *= this.phaseY;
                    } else {
                        bottom *= this.phaseY;
                    }
                    this.addBar(left, top, right, bottom);
                } else {
                    float posY = 0.0f;
                    float negY = -e.getNegativeSum();
                    float yStart = 0.0f;
                    for (int k = 0; k < vals.length; ++k) {
                        float top;
                        float bottom;
                        float value = vals[k];
                        if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                            yStart = y = value;
                        } else if (value >= 0.0f) {
                            y = posY;
                            posY = yStart = posY + value;
                        } else {
                            y = negY;
                            yStart = negY + Math.abs(value);
                            negY += Math.abs(value);
                        }
                        float left = x - barWidthHalf;
                        float right = x + barWidthHalf;
                        if (this.mInverted) {
                            bottom = y >= yStart ? y : yStart;
                            top = y <= yStart ? y : yStart;
                        } else {
                            top = y >= yStart ? y : yStart;
                            bottom = y <= yStart ? y : yStart;
                        }
                        this.addBar(left, top *= this.phaseY, right, bottom *= this.phaseY);
                    }
                }
            }
            ++i;
        }
        this.reset();
    }
}

