/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.filter;

import android.annotation.TargetApi;
import java.util.Arrays;

public class Approximator {
    @TargetApi(value=9)
    public float[] reduceWithDouglasPeucker(float[] points, float tolerance) {
        int greatestIndex = 0;
        float greatestDistance = 0.0f;
        Line line = new Line(points[0], points[1], points[points.length - 2], points[points.length - 1]);
        for (int i = 2; i < points.length - 2; i += 2) {
            float distance = line.distance(points[i], points[i + 1]);
            if (!(distance > greatestDistance)) continue;
            greatestDistance = distance;
            greatestIndex = i;
        }
        if (greatestDistance > tolerance) {
            float[] reduced1 = this.reduceWithDouglasPeucker(Arrays.copyOfRange(points, 0, greatestIndex + 2), tolerance);
            float[] reduced2 = this.reduceWithDouglasPeucker(Arrays.copyOfRange(points, greatestIndex, points.length), tolerance);
            float[] result1 = reduced1;
            float[] result2 = Arrays.copyOfRange(reduced2, 2, reduced2.length);
            return this.concat(result1, result2);
        }
        return line.getPoints();
    }

    float[] concat(float[] ... arrays) {
        int length = 0;
        for (float[] array : arrays) {
            length += array.length;
        }
        float[] result = new float[length];
        int pos = 0;
        float[][] fArray = arrays;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] array;
            float[] fArray2 = array = fArray[i];
            int n2 = fArray2.length;
            for (int j = 0; j < n2; ++j) {
                float element;
                result[pos] = element = fArray2[j];
                ++pos;
            }
        }
        return result;
    }

    private class Line {
        private float[] points;
        private float sxey;
        private float exsy;
        private float dx;
        private float dy;
        private float length;

        public Line(float x1, float y1, float x2, float y2) {
            this.dx = x1 - x2;
            this.dy = y1 - y2;
            this.sxey = x1 * y2;
            this.exsy = x2 * y1;
            this.length = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
            this.points = new float[]{x1, y1, x2, y2};
        }

        public float distance(float x, float y) {
            return Math.abs(this.dy * x - this.dx * y + this.sxey - this.exsy) / this.length;
        }

        public float[] getPoints() {
            return this.points;
        }
    }
}

