/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.listener.OnChartGestureListener;

public abstract class ChartTouchListener<T extends Chart<?>>
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    protected ChartGesture mLastGesture = ChartGesture.NONE;
    protected static final int NONE = 0;
    protected static final int DRAG = 1;
    protected static final int X_ZOOM = 2;
    protected static final int Y_ZOOM = 3;
    protected static final int PINCH_ZOOM = 4;
    protected static final int POST_ZOOM = 5;
    protected static final int ROTATE = 6;
    protected int mTouchMode = 0;
    protected Highlight mLastHighlighted;
    protected GestureDetector mGestureDetector;
    protected T mChart;

    public ChartTouchListener(T chart) {
        this.mChart = chart;
        this.mGestureDetector = new GestureDetector(chart.getContext(), (GestureDetector.OnGestureListener)this);
    }

    public void startAction(MotionEvent me) {
        OnChartGestureListener l = ((Chart)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartGestureStart(me, this.mLastGesture);
        }
    }

    public void endAction(MotionEvent me) {
        OnChartGestureListener l = ((Chart)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartGestureEnd(me, this.mLastGesture);
        }
    }

    public void setLastHighlighted(Highlight high) {
        this.mLastHighlighted = high;
    }

    public int getTouchMode() {
        return this.mTouchMode;
    }

    public ChartGesture getLastGesture() {
        return this.mLastGesture;
    }

    protected void performHighlight(Highlight h, MotionEvent e) {
        if (h != null && !h.equalTo(this.mLastHighlighted)) {
            ((Chart)this.mChart).highlightValue(h, true);
            this.mLastHighlighted = h;
        }
    }

    protected static float distance(float eventX, float startX, float eventY, float startY) {
        float dx = eventX - startX;
        float dy = eventY - startY;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static enum ChartGesture {
        NONE,
        DRAG,
        X_ZOOM,
        Y_ZOOM,
        PINCH_ZOOM,
        ROTATE,
        SINGLE_TAP,
        DOUBLE_TAP,
        LONG_PRESS,
        FLING;

    }
}

