/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.core;

import com.gitlab.mvysny.umn.core.DocumentSerializer;
import com.gitlab.mvysny.umn.core.TypeToClassResolver;
import com.gitlab.mvysny.umn.core.UMN;
import com.gitlab.mvysny.umn.core.UtilsKt;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u0017\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord;", "", "id", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "getId", "()Ljava/util/UUID;", "applyTo", "", "umn", "Lcom/gitlab/mvysny/umn/core/UMN;", "toByteArray", "", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "writeTo", "dout", "Ljava/io/DataOutputStream;", "Companion", "DocumentCreated", "DocumentCreated2", "DocumentDeleted", "DocumentUpdated", "Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentCreated;", "Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentCreated2;", "Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentDeleted;", "Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentUpdated;", "umn-core"})
public abstract class LogRecord {
    @NotNull
    private final UUID id;
    private static final int TYPE_DOCUMENT_CREATED = 0;
    private static final int TYPE_DOCUMENT_DELETED = 1;
    private static final int TYPE_DOCUMENT_UPDATED = 2;
    public static final Companion Companion = new Companion(null);

    public abstract void writeTo(@NotNull DataOutputStream var1, @NotNull DocumentSerializer var2);

    @NotNull
    public final byte[] toByteArray(@NotNull DocumentSerializer serializer) {
        Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
        return UtilsKt.serializeData((Function1<? super DataOutputStream, Unit>)((Function1)new Function1<DataOutputStream, Unit>(this, serializer){
            final /* synthetic */ LogRecord this$0;
            final /* synthetic */ DocumentSerializer $serializer;

            public final void invoke(@NotNull DataOutputStream $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.writeTo($receiver, this.$serializer);
            }
            {
                this.this$0 = logRecord;
                this.$serializer = documentSerializer;
                super(1);
            }
        }));
    }

    public abstract void applyTo(@NotNull UMN var1);

    @NotNull
    public UUID getId() {
        return this.id;
    }

    private LogRecord(UUID id) {
        this.id = id;
    }

    static {
        TYPE_DOCUMENT_DELETED = 1;
        TYPE_DOCUMENT_UPDATED = 2;
    }

    public /* synthetic */ LogRecord(@NotNull UUID id, DefaultConstructorMarker $constructor_marker) {
        this(id);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentCreated;", "Lcom/gitlab/mvysny/umn/core/LogRecord;", "document", "", "type", "", "id", "Ljava/util/UUID;", "(Ljava/lang/Object;SLjava/util/UUID;)V", "getDocument", "()Ljava/lang/Object;", "getId", "()Ljava/util/UUID;", "getType", "()S", "applyTo", "", "umn", "Lcom/gitlab/mvysny/umn/core/UMN;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "writeTo", "dout", "Ljava/io/DataOutputStream;", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "Companion", "umn-core"})
    public static final class DocumentCreated
    extends LogRecord {
        @NotNull
        private final Object document;
        private final short type;
        @NotNull
        private final UUID id;
        public static final Companion Companion = new Companion(null);

        @Override
        public void applyTo(@NotNull UMN umn) {
            Intrinsics.checkParameterIsNotNull((Object)umn, (String)"umn");
            umn.create(this.document, this.getId());
        }

        @Override
        public void writeTo(@NotNull DataOutputStream dout, @NotNull DocumentSerializer serializer) {
            Intrinsics.checkParameterIsNotNull((Object)dout, (String)"dout");
            Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
            dout.writeByte(TYPE_DOCUMENT_CREATED);
            dout.writeLong(this.getId().getLeastSignificantBits());
            dout.writeLong(this.getId().getMostSignificantBits());
            dout.writeShort(this.type);
            serializer.serialize(this.document, dout);
        }

        @NotNull
        public final Object getDocument() {
            return this.document;
        }

        public final short getType() {
            return this.type;
        }

        @Override
        @NotNull
        public UUID getId() {
            return this.id;
        }

        public DocumentCreated(@NotNull Object document, short type, @NotNull UUID id) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            super(id, null);
            this.document = document;
            this.type = type;
            this.id = id;
        }

        @NotNull
        public final Object component1() {
            return this.document;
        }

        public final short component2() {
            return this.type;
        }

        @NotNull
        public final UUID component3() {
            return this.getId();
        }

        @NotNull
        public final DocumentCreated copy(@NotNull Object document, short type, @NotNull UUID id) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new DocumentCreated(document, type, id);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DocumentCreated copy$default(DocumentCreated documentCreated, Object object, short s, UUID uUID, int n, Object object2) {
            if ((n & 1) != 0) {
                object = documentCreated.document;
            }
            if ((n & 2) != 0) {
                s = documentCreated.type;
            }
            if ((n & 4) != 0) {
                uUID = documentCreated.getId();
            }
            return documentCreated.copy(object, s, uUID);
        }

        @NotNull
        public String toString() {
            return "DocumentCreated(document=" + this.document + ", type=" + this.type + ", id=" + this.getId() + ")";
        }

        public int hashCode() {
            Object object = this.document;
            UUID uUID = this.getId();
            return ((object != null ? object.hashCode() : 0) * 31 + this.type) * 31 + (uUID != null ? ((Object)uUID).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DocumentCreated)) break block3;
                    DocumentCreated documentCreated = (DocumentCreated)object;
                    if (!Intrinsics.areEqual((Object)this.document, (Object)documentCreated.document) || !(this.type == documentCreated.type) || !Intrinsics.areEqual((Object)this.getId(), (Object)documentCreated.getId())) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentCreated$Companion;", "", "()V", "readFrom", "Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentCreated;", "id", "Ljava/util/UUID;", "din", "Ljava/io/DataInputStream;", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "typeToClassResolver", "Lcom/gitlab/mvysny/umn/core/TypeToClassResolver;", "readFrom$umn_core", "umn-core"})
        public static final class Companion {
            @NotNull
            public final DocumentCreated readFrom$umn_core(@NotNull UUID id, @NotNull DataInputStream din, @NotNull DocumentSerializer serializer, @NotNull TypeToClassResolver typeToClassResolver) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull((Object)din, (String)"din");
                Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
                Intrinsics.checkParameterIsNotNull((Object)typeToClassResolver, (String)"typeToClassResolver");
                short type = din.readShort();
                KClass<?> clazz = typeToClassResolver.toClass(type);
                Object doc = serializer.deserialize(clazz, din);
                return new DocumentCreated(doc, type, id);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentCreated2;", "Lcom/gitlab/mvysny/umn/core/LogRecord;", "serializedDocumentWithType", "", "Lcom/gitlab/mvysny/umn/core/SerializedDocument;", "id", "Ljava/util/UUID;", "([BLjava/util/UUID;)V", "getId", "()Ljava/util/UUID;", "getSerializedDocumentWithType", "()[B", "applyTo", "", "umn", "Lcom/gitlab/mvysny/umn/core/UMN;", "writeTo", "dout", "Ljava/io/DataOutputStream;", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "umn-core"})
    public static final class DocumentCreated2
    extends LogRecord {
        @NotNull
        private final byte[] serializedDocumentWithType;
        @NotNull
        private final UUID id;

        @Override
        public void applyTo(@NotNull UMN umn) {
            Intrinsics.checkParameterIsNotNull((Object)umn, (String)"umn");
            throw (Throwable)new IllegalStateException("Should not be called");
        }

        @Override
        public void writeTo(@NotNull DataOutputStream dout, @NotNull DocumentSerializer serializer) {
            Intrinsics.checkParameterIsNotNull((Object)dout, (String)"dout");
            Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
            dout.writeByte(TYPE_DOCUMENT_CREATED);
            dout.writeLong(this.getId().getLeastSignificantBits());
            dout.writeLong(this.getId().getMostSignificantBits());
            dout.write(this.serializedDocumentWithType);
        }

        @NotNull
        public final byte[] getSerializedDocumentWithType() {
            return this.serializedDocumentWithType;
        }

        @Override
        @NotNull
        public UUID getId() {
            return this.id;
        }

        public DocumentCreated2(@NotNull byte[] serializedDocumentWithType, @NotNull UUID id) {
            Intrinsics.checkParameterIsNotNull((Object)serializedDocumentWithType, (String)"serializedDocumentWithType");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            super(id, null);
            this.serializedDocumentWithType = serializedDocumentWithType;
            this.id = id;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentDeleted;", "Lcom/gitlab/mvysny/umn/core/LogRecord;", "id", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "getId", "()Ljava/util/UUID;", "applyTo", "", "umn", "Lcom/gitlab/mvysny/umn/core/UMN;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "writeTo", "dout", "Ljava/io/DataOutputStream;", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "Companion", "umn-core"})
    public static final class DocumentDeleted
    extends LogRecord {
        @NotNull
        private final UUID id;
        public static final Companion Companion = new Companion(null);

        @Override
        public void applyTo(@NotNull UMN umn) {
            Intrinsics.checkParameterIsNotNull((Object)umn, (String)"umn");
            umn.delete(this.getId());
        }

        @Override
        public void writeTo(@NotNull DataOutputStream dout, @NotNull DocumentSerializer serializer) {
            Intrinsics.checkParameterIsNotNull((Object)dout, (String)"dout");
            Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
            dout.writeByte(TYPE_DOCUMENT_DELETED);
            dout.writeLong(this.getId().getLeastSignificantBits());
            dout.writeLong(this.getId().getMostSignificantBits());
        }

        @Override
        @NotNull
        public UUID getId() {
            return this.id;
        }

        public DocumentDeleted(@NotNull UUID id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            super(id, null);
            this.id = id;
        }

        @NotNull
        public final UUID component1() {
            return this.getId();
        }

        @NotNull
        public final DocumentDeleted copy(@NotNull UUID id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new DocumentDeleted(id);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DocumentDeleted copy$default(DocumentDeleted documentDeleted, UUID uUID, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = documentDeleted.getId();
            }
            return documentDeleted.copy(uUID);
        }

        @NotNull
        public String toString() {
            return "DocumentDeleted(id=" + this.getId() + ")";
        }

        public int hashCode() {
            UUID uUID = this.getId();
            return uUID != null ? ((Object)uUID).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DocumentDeleted)) break block3;
                    DocumentDeleted documentDeleted = (DocumentDeleted)object;
                    if (!Intrinsics.areEqual((Object)this.getId(), (Object)documentDeleted.getId())) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentDeleted$Companion;", "", "()V", "readFrom", "Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentDeleted;", "id", "Ljava/util/UUID;", "readFrom$umn_core", "umn-core"})
        public static final class Companion {
            @NotNull
            public final DocumentDeleted readFrom$umn_core(@NotNull UUID id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                return new DocumentDeleted(id);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentUpdated;", "Lcom/gitlab/mvysny/umn/core/LogRecord;", "document", "", "type", "", "id", "Ljava/util/UUID;", "(Ljava/lang/Object;SLjava/util/UUID;)V", "getDocument", "()Ljava/lang/Object;", "getId", "()Ljava/util/UUID;", "getType", "()S", "applyTo", "", "umn", "Lcom/gitlab/mvysny/umn/core/UMN;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "writeTo", "dout", "Ljava/io/DataOutputStream;", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "Companion", "umn-core"})
    public static final class DocumentUpdated
    extends LogRecord {
        @NotNull
        private final Object document;
        private final short type;
        @NotNull
        private final UUID id;
        public static final Companion Companion = new Companion(null);

        @Override
        public void applyTo(@NotNull UMN umn) {
            Intrinsics.checkParameterIsNotNull((Object)umn, (String)"umn");
            if (umn.exists(this.getId())) {
                umn.update(this.getId(), this.document);
            }
        }

        @Override
        public void writeTo(@NotNull DataOutputStream dout, @NotNull DocumentSerializer serializer) {
            Intrinsics.checkParameterIsNotNull((Object)dout, (String)"dout");
            Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
            dout.writeByte(TYPE_DOCUMENT_UPDATED);
            dout.writeLong(this.getId().getLeastSignificantBits());
            dout.writeLong(this.getId().getMostSignificantBits());
            dout.writeShort(this.type);
            serializer.serialize(this.document, dout);
        }

        @NotNull
        public final Object getDocument() {
            return this.document;
        }

        public final short getType() {
            return this.type;
        }

        @Override
        @NotNull
        public UUID getId() {
            return this.id;
        }

        public DocumentUpdated(@NotNull Object document, short type, @NotNull UUID id) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            super(id, null);
            this.document = document;
            this.type = type;
            this.id = id;
        }

        @NotNull
        public final Object component1() {
            return this.document;
        }

        public final short component2() {
            return this.type;
        }

        @NotNull
        public final UUID component3() {
            return this.getId();
        }

        @NotNull
        public final DocumentUpdated copy(@NotNull Object document, short type, @NotNull UUID id) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new DocumentUpdated(document, type, id);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DocumentUpdated copy$default(DocumentUpdated documentUpdated, Object object, short s, UUID uUID, int n, Object object2) {
            if ((n & 1) != 0) {
                object = documentUpdated.document;
            }
            if ((n & 2) != 0) {
                s = documentUpdated.type;
            }
            if ((n & 4) != 0) {
                uUID = documentUpdated.getId();
            }
            return documentUpdated.copy(object, s, uUID);
        }

        @NotNull
        public String toString() {
            return "DocumentUpdated(document=" + this.document + ", type=" + this.type + ", id=" + this.getId() + ")";
        }

        public int hashCode() {
            Object object = this.document;
            UUID uUID = this.getId();
            return ((object != null ? object.hashCode() : 0) * 31 + this.type) * 31 + (uUID != null ? ((Object)uUID).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DocumentUpdated)) break block3;
                    DocumentUpdated documentUpdated = (DocumentUpdated)object;
                    if (!Intrinsics.areEqual((Object)this.document, (Object)documentUpdated.document) || !(this.type == documentUpdated.type) || !Intrinsics.areEqual((Object)this.getId(), (Object)documentUpdated.getId())) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentUpdated$Companion;", "", "()V", "readFrom", "Lcom/gitlab/mvysny/umn/core/LogRecord$DocumentUpdated;", "id", "Ljava/util/UUID;", "din", "Ljava/io/DataInputStream;", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "typeToClassResolver", "Lcom/gitlab/mvysny/umn/core/TypeToClassResolver;", "readFrom$umn_core", "umn-core"})
        public static final class Companion {
            @NotNull
            public final DocumentUpdated readFrom$umn_core(@NotNull UUID id, @NotNull DataInputStream din, @NotNull DocumentSerializer serializer, @NotNull TypeToClassResolver typeToClassResolver) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull((Object)din, (String)"din");
                Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
                Intrinsics.checkParameterIsNotNull((Object)typeToClassResolver, (String)"typeToClassResolver");
                short type = din.readShort();
                KClass<?> clazz = typeToClassResolver.toClass(type);
                Object doc = serializer.deserialize(clazz, din);
                return new DocumentUpdated(doc, type, id);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/gitlab/mvysny/umn/core/LogRecord$Companion;", "", "()V", "TYPE_DOCUMENT_CREATED", "", "TYPE_DOCUMENT_DELETED", "TYPE_DOCUMENT_UPDATED", "fromByteArray", "Lcom/gitlab/mvysny/umn/core/LogRecord;", "bytes", "", "Lcom/gitlab/mvysny/umn/sync/SerializedLogRecord;", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "typeToClassResolver", "Lcom/gitlab/mvysny/umn/core/TypeToClassResolver;", "readFrom", "din", "Ljava/io/DataInputStream;", "umn-core"})
    public static final class Companion {
        private final LogRecord readFrom(DataInputStream din, DocumentSerializer serializer, TypeToClassResolver typeToClassResolver) {
            LogRecord logRecord;
            byte type = din.readByte();
            long lsb = din.readLong();
            long msb = din.readLong();
            UUID id = new UUID(msb, lsb);
            byte by = type;
            if (by == TYPE_DOCUMENT_CREATED) {
                logRecord = DocumentCreated.Companion.readFrom$umn_core(id, din, serializer, typeToClassResolver);
            } else if (by == TYPE_DOCUMENT_DELETED) {
                logRecord = DocumentDeleted.Companion.readFrom$umn_core(id);
            } else if (by == TYPE_DOCUMENT_UPDATED) {
                logRecord = DocumentUpdated.Companion.readFrom$umn_core(id, din, serializer, typeToClassResolver);
            } else {
                throw (Throwable)new RuntimeException("Unsupported document type: " + type);
            }
            return logRecord;
        }

        @NotNull
        public final LogRecord fromByteArray(@NotNull byte[] bytes, @NotNull DocumentSerializer serializer, @NotNull TypeToClassResolver typeToClassResolver) {
            DataInputStream dataInputStream;
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
            Intrinsics.checkParameterIsNotNull((Object)typeToClassResolver, (String)"typeToClassResolver");
            byte[] byArray = bytes;
            DataInputStream dataInputStream2 = dataInputStream;
            DataInputStream dataInputStream3 = dataInputStream;
            Companion companion = this;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream2(byteArrayInputStream);
            return companion.readFrom(dataInputStream3, serializer, typeToClassResolver);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

