/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.core;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u001a\n\u0010\u0007\u001a\u00020\u0005*\u00020\b\u001a9\u0010\t\u001a\u00020\u0005\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b*\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\f2\u0006\u0010\r\u001a\u0002H\n2\b\u0010\u000e\u001a\u0004\u0018\u0001H\u000b\u00a2\u0006\u0002\u0010\u000f\u001a'\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\b*\u0002H\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"serializeData", "", "block", "Lkotlin/Function1;", "Ljava/io/DataOutputStream;", "", "Lkotlin/ExtensionFunctionType;", "closeQuietly", "Ljava/io/Closeable;", "putOrRemove", "K", "V", "", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "tryInit", "T", "Lkotlin/Function0;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function0;)Ljava/io/Closeable;", "umn-core"})
public final class UtilsKt {
    public static final <K, V> void putOrRemove(@NotNull Map<K, V> $receiver, K key, @Nullable V value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (value == null) {
            $receiver.remove(key);
        } else {
            $receiver.put(key, value);
        }
    }

    public static final void closeQuietly(@NotNull Closeable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            $receiver.close();
        }
        catch (Exception t) {
            LoggerFactory.getLogger($receiver.getClass()).warn("Failed to close " + $receiver, (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final <T extends Closeable> T tryInit(@NotNull T $receiver, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            block.invoke();
        }
        catch (Throwable t) {
            try {
                $receiver.close();
            }
            catch (Throwable ex) {
                t.addSuppressed(ex);
            }
            finally {
                throw t;
            }
        }
        return $receiver;
    }

    @NotNull
    public static final byte[] serializeData(@NotNull Function1<? super DataOutputStream, Unit> block) {
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ByteArrayOutputStream $receiver = byteArrayOutputStream = new ByteArrayOutputStream();
        block.invoke((Object)new DataOutputStream($receiver));
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ByteArrayOutputStream().\u2026.block() } .toByteArray()");
        return byArray;
    }
}

