/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.sync;

import com.gitlab.mvysny.umn.sync.GlobalLogClient;
import com.gitlab.mvysny.umn.sync.InMemoryGlobalLog;
import com.gitlab.mvysny.umn.sync.InMemoryGlobalLogClient;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010!\u001a\u00020\u00072\n\u0010\u001b\u001a\u00060\u0017j\u0002`\u0018H\u0016J\b\u0010\"\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020\u0007H\u0002J\b\u0010$\u001a\u00020\u0007H\u0016J\u0019\u0010%\u001a\u00020\u00072\n\u0010\u001b\u001a\u00060\u0017j\u0002`\u0018H\u0000\u00a2\u0006\u0002\b&J\u0016\u0010'\u001a\u00020\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J7\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u000f2%\u0010(\u001a!\u0012\u0017\u0012\u00150\u0017j\u0002`\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00070\u0016H\u0016J\b\u0010+\u001a\u00020\u0007H\u0016R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R9\u0010\u0015\u001a!\u0012\u0017\u0012\u00150\u0017j\u0002`\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00070\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/gitlab/mvysny/umn/sync/InMemoryGlobalLogClient;", "Lcom/gitlab/mvysny/umn/sync/GlobalLogClient;", "owner", "Lcom/gitlab/mvysny/umn/sync/InMemoryGlobalLog;", "(Lcom/gitlab/mvysny/umn/sync/InMemoryGlobalLog;)V", "addCallback", "Lkotlin/Function0;", "", "getAddCallback$umn_core", "()Lkotlin/jvm/functions/Function0;", "setAddCallback$umn_core", "(Lkotlin/jvm/functions/Function0;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentLogPointer", "", "isStarted", "", "()Z", "getOwner", "()Lcom/gitlab/mvysny/umn/sync/InMemoryGlobalLog;", "receiveCallback", "Lkotlin/Function1;", "", "Lcom/gitlab/mvysny/umn/sync/SerializedLogRecord;", "Lkotlin/ParameterName;", "name", "record", "getReceiveCallback$umn_core", "()Lkotlin/jvm/functions/Function1;", "setReceiveCallback$umn_core", "(Lkotlin/jvm/functions/Function1;)V", "started", "addAsync", "checkNotClosed", "checkNotStarted", "close", "onNewItem", "onNewItem$umn_core", "setAddCallback", "callback", "setReceiverCallback", "rewind", "start", "umn-core"})
public final class InMemoryGlobalLogClient
implements GlobalLogClient {
    private final AtomicBoolean closed;
    private final AtomicBoolean started;
    @NotNull
    private Function0<Unit> addCallback;
    @NotNull
    private Function1<? super byte[], Unit> receiveCallback;
    private long currentLogPointer;
    @NotNull
    private final InMemoryGlobalLog owner;

    @Override
    public boolean isStarted() {
        return this.started.get() && !this.closed.get();
    }

    @NotNull
    public final Function0<Unit> getAddCallback$umn_core() {
        return this.addCallback;
    }

    public final void setAddCallback$umn_core(@NotNull Function0<Unit> function0) {
        Intrinsics.checkParameterIsNotNull(function0, (String)"<set-?>");
        this.addCallback = function0;
    }

    @NotNull
    public final Function1<byte[], Unit> getReceiveCallback$umn_core() {
        return this.receiveCallback;
    }

    public final void setReceiveCallback$umn_core(@NotNull Function1<? super byte[], Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.receiveCallback = function1;
    }

    private final void checkNotClosed() {
        boolean bl;
        boolean bl2 = bl = !this.closed.get();
        if (!bl) {
            String string = "Already closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void checkNotStarted() {
        boolean bl;
        boolean bl2 = bl = !this.started.get();
        if (!bl) {
            String string = "Already started";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public void start() {
        this.checkNotClosed();
        boolean bl = this.started.compareAndSet(false, true);
        if (!bl) {
            String string = "Already started";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        List<byte[]> logItems = this.owner.startClient$umn_core(this, this.currentLogPointer);
        for (byte[] logItem : logItems) {
            this.onNewItem$umn_core(logItem);
        }
    }

    @Override
    public void setAddCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.checkNotStarted();
        this.addCallback = callback;
    }

    @Override
    public void setReceiverCallback(long rewind, @NotNull Function1<? super byte[], Unit> callback) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        boolean bl2 = bl = rewind >= 0L;
        if (!bl) {
            String string = "Parameter rewind: invalid value " + rewind + " - must be 0 or greater";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.checkNotStarted();
        this.currentLogPointer = rewind;
        this.receiveCallback = callback;
    }

    @Override
    public void addAsync(@NotNull byte[] record) {
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        boolean bl = this.started.get();
        if (!bl) {
            String string = "Not yet started";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.checkNotClosed();
        this.owner.add$umn_core(this, record);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.owner.close$umn_core(this);
        }
    }

    public final synchronized void onNewItem$umn_core(@NotNull byte[] record) {
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        this.receiveCallback.invoke((Object)record);
        long l = this.currentLogPointer;
        this.currentLogPointer = l + 1L;
    }

    @NotNull
    public final InMemoryGlobalLog getOwner() {
        return this.owner;
    }

    public InMemoryGlobalLogClient(@NotNull InMemoryGlobalLog owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        this.owner = owner;
        this.closed = new AtomicBoolean();
        this.started = new AtomicBoolean();
        this.addCallback = addCallback.1.INSTANCE;
        this.receiveCallback = receiveCallback.1.INSTANCE;
    }
}

