/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.sync;

import com.gitlab.mvysny.umn.core.UtilsKt;
import com.gitlab.mvysny.umn.sync.GlobalLogClient;
import com.gitlab.mvysny.umn.sync.MVStoreGlobalLogClient;
import com.gitlab.mvysny.umn.sync.PasswordHash;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000fJ\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001cJb\u0010\u001d\u001aV\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f\u0012\u0016\u0012\u0014  *\n\u0018\u00010!j\u0004\u0018\u0001`\"0!j\u0002`\"  **\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f\u0012\u0016\u0012\u0014  *\n\u0018\u00010!j\u0004\u0018\u0001`\"0!j\u0002`\"\u0018\u00010\u001e0\u001e2\u0006\u0010\u0017\u001a\u00020\u000fJ\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0$J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0&J\u0016\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0015\u0010)\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b*R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/gitlab/mvysny/umn/sync/MVStoreGlobalLog;", "Ljava/io/Closeable;", "db", "Lorg/h2/mvstore/MVStore;", "(Lorg/h2/mvstore/MVStore;)V", "activeClientCount", "", "getActiveClientCount", "()I", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getDb", "()Lorg/h2/mvstore/MVStore;", "startedClients", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/BlockingQueue;", "Lcom/gitlab/mvysny/umn/sync/MVStoreGlobalLogClient;", "close", "", "client", "close$umn_core", "createOrUpdateUser", "username", "password", "deleteAllUsers", "deleteUser", "fireNewItemNotification", "fireNewItemNotification$umn_core", "getLogMap", "Lorg/h2/mvstore/MVMap;", "", "kotlin.jvm.PlatformType", "", "Lcom/gitlab/mvysny/umn/sync/SerializedLogRecord;", "getLogSizes", "", "listUsers", "", "newClient", "Lcom/gitlab/mvysny/umn/sync/GlobalLogClient;", "startClient", "startClient$umn_core", "umn-core"})
public final class MVStoreGlobalLog
implements Closeable {
    private final ConcurrentHashMap<String, BlockingQueue<MVStoreGlobalLogClient>> startedClients;
    private final AtomicBoolean closed;
    @NotNull
    private final MVStore db;

    @NotNull
    public final GlobalLogClient newClient(@NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        return new MVStoreGlobalLogClient(this, username, password);
    }

    /*
     * WARNING - void declaration
     */
    public final void startClient$umn_core(@NotNull MVStoreGlobalLogClient client) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        ConcurrentMap concurrentMap = this.startedClients;
        String key$iv = client.getUsername();
        Object object = $receiver$iv.get(key$iv);
        if (object == null) {
            LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
            LinkedBlockingQueue default$iv = linkedBlockingQueue;
            object = $receiver$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        BlockingQueue clientsForUsername = (BlockingQueue)object;
        clientsForUsername.add(client);
    }

    public final void close$umn_core(@NotNull MVStoreGlobalLogClient client) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            BlockingQueue<MVStoreGlobalLogClient> blockingQueue = this.startedClients.get(client.getUsername());
            if (blockingQueue == null) break block0;
            blockingQueue.remove(client);
        }
    }

    public final void fireNewItemNotification$umn_core(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        BlockingQueue<MVStoreGlobalLogClient> blockingQueue = this.startedClients.get(username);
        if (blockingQueue != null) {
            Iterable $receiver$iv = blockingQueue;
            for (Object element$iv : $receiver$iv) {
                MVStoreGlobalLogClient it = (MVStoreGlobalLogClient)element$iv;
                it.onNewItems$umn_core();
            }
        }
    }

    public final void createOrUpdateUser(@NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        MVMap mVMap = this.db.openMap("users");
        Intrinsics.checkExpressionValueIsNotNull((Object)mVMap, (String)"db.openMap<String, String>(\"users\")");
        Map map = (Map)mVMap;
        String string = PasswordHash.createHash(password);
        map.put(username, string);
    }

    @NotNull
    public final List<String> listUsers() {
        List list = this.db.openMap("users").keyList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"db.openMap<String, String>(\"users\").keyList()");
        return CollectionsKt.filterNotNull((Iterable)list);
    }

    public final void deleteUser(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        this.db.openMap("users").remove((Object)username);
        this.db.removeMap(this.getLogMap(username));
    }

    public final MVMap<Long, byte[]> getLogMap(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        return this.db.openMap(username + "__log");
    }

    public final void deleteAllUsers() {
        Iterable $receiver$iv = this.listUsers();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            this.deleteUser(it);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Collection<BlockingQueue<MVStoreGlobalLogClient>> collection = this.startedClients.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"startedClients.values");
            Iterable $receiver$iv = CollectionsKt.flatten((Iterable)collection);
            for (Object element$iv : $receiver$iv) {
                MVStoreGlobalLogClient it;
                MVStoreGlobalLogClient mVStoreGlobalLogClient = it = (MVStoreGlobalLogClient)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)mVStoreGlobalLogClient, (String)"it");
                UtilsKt.closeQuietly(mVStoreGlobalLogClient);
            }
            this.startedClients.clear();
            this.db.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Long> getLogSizes() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.listUsers();
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it;
            String string = (String)element$iv$iv;
            Map map = destination$iv$iv;
            void var12_9 = it;
            it = (String)element$iv$iv;
            Long l = this.getLogMap(it).sizeAsLong();
            map.put(var12_9, l);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final int getActiveClientCount() {
        void var2_2;
        Collection<BlockingQueue<MVStoreGlobalLogClient>> collection = this.startedClients.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"startedClients.values");
        Iterable $receiver$iv = collection;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            BlockingQueue blockingQueue = (BlockingQueue)element$iv;
            int n = sum$iv;
            int n2 = it.size();
            sum$iv = n + n2;
        }
        return (int)var2_2;
    }

    @NotNull
    public final MVStore getDb() {
        return this.db;
    }

    public MVStoreGlobalLog(@NotNull MVStore db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        this.db = db;
        this.startedClients = new ConcurrentHashMap();
        this.closed = new AtomicBoolean(false);
    }
}

