/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.sync;

import com.gitlab.mvysny.umn.core.UtilityMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0011\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/gitlab/mvysny/umn/sync/AckFIFOBuffer;", "T", "", "log", "Lcom/gitlab/mvysny/umn/core/UtilityMap;", "", "(Lcom/gitlab/mvysny/umn/core/UtilityMap;)V", "idOfItemToAck", "idOfItemToPoll", "idToAddTo", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "ackLowest", "", "append", "item", "(Ljava/lang/Object;)V", "poll", "()Ljava/lang/Object;", "umn-core"})
public final class AckFIFOBuffer<T> {
    private long idToAddTo;
    private long idOfItemToPoll;
    private long idOfItemToAck;
    private final ReentrantLock lock;
    private final UtilityMap<Long, T> log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void append(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        Lock lock = this.lock;
        lock.lock();
        try {
            long l = this.idToAddTo;
            this.idToAddTo = l + 1L;
            this.log.put((Long)((Comparable)Long.valueOf(l)), item);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ackLowest() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.idOfItemToAck < this.idToAddTo) {
                long l = this.idOfItemToAck;
                this.idOfItemToAck = l + 1L;
                this.log.put((Long)((Comparable)Long.valueOf(l)), null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T poll() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.idOfItemToPoll < this.idToAddTo) {
                long l = this.idOfItemToPoll;
                this.idOfItemToPoll = l + 1L;
                T t = this.log.find((Long)((Comparable)Long.valueOf(l)));
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                T t2 = t;
                return t2;
            }
            T t = null;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public AckFIFOBuffer(@NotNull UtilityMap<Long, T> log) {
        Intrinsics.checkParameterIsNotNull(log, (String)"log");
        this.log = log;
        Long l = this.log.getLargestKey();
        this.idToAddTo = (l != null ? l : -1L) + 1L;
        Long l2 = this.log.getSmallestKey();
        this.idOfItemToAck = this.idOfItemToPoll = l2 != null ? l2 : 0L;
        this.lock = new ReentrantLock();
    }
}

