/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.sync;

import com.gitlab.mvysny.umn.sync.GlobalLogClient;
import com.gitlab.mvysny.umn.sync.InvalidUsernamePasswordException;
import com.gitlab.mvysny.umn.sync.MVStoreGlobalLog;
import com.gitlab.mvysny.umn.sync.MVStoreGlobalLogClient;
import com.gitlab.mvysny.umn.sync.MVStoreGlobalLogKt;
import com.gitlab.mvysny.umn.sync.PasswordHash;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.MVMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010(\u001a\u00020\n2\n\u0010 \u001a\u00060\u0018j\u0002`\u0019H\u0016J\b\u0010)\u001a\u00020\nH\u0002J\b\u0010*\u001a\u00020\nH\u0002J\b\u0010+\u001a\u00020\nH\u0016J\r\u0010,\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b-J\u0016\u0010.\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J7\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\u00122%\u0010/\u001a!\u0012\u0017\u0012\u00150\u0018j\u0002`\u0019\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\n0\u001dH\u0016J\b\u00102\u001a\u00020\nH\u0016R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u00060\u0018j\u0002`\u00190\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u001c\u001a!\u0012\u0017\u0012\u00150\u0018j\u0002`\u0019\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\n0\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00063"}, d2={"Lcom/gitlab/mvysny/umn/sync/MVStoreGlobalLogClient;", "Lcom/gitlab/mvysny/umn/sync/GlobalLogClient;", "owner", "Lcom/gitlab/mvysny/umn/sync/MVStoreGlobalLog;", "username", "", "password", "(Lcom/gitlab/mvysny/umn/sync/MVStoreGlobalLog;Ljava/lang/String;Ljava/lang/String;)V", "addCallback", "Lkotlin/Function0;", "", "getAddCallback$umn_core", "()Lkotlin/jvm/functions/Function0;", "setAddCallback$umn_core", "(Lkotlin/jvm/functions/Function0;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentLogPointer", "", "isStarted", "", "()Z", "log", "Lorg/h2/mvstore/MVMap;", "", "Lcom/gitlab/mvysny/umn/sync/SerializedLogRecord;", "getOwner", "()Lcom/gitlab/mvysny/umn/sync/MVStoreGlobalLog;", "receiveCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "record", "getReceiveCallback$umn_core", "()Lkotlin/jvm/functions/Function1;", "setReceiveCallback$umn_core", "(Lkotlin/jvm/functions/Function1;)V", "started", "getUsername", "()Ljava/lang/String;", "addAsync", "checkNotClosed", "checkNotStarted", "close", "onNewItems", "onNewItems$umn_core", "setAddCallback", "callback", "setReceiverCallback", "rewind", "start", "umn-core"})
public final class MVStoreGlobalLogClient
implements GlobalLogClient {
    private final AtomicBoolean closed;
    private final AtomicBoolean started;
    @NotNull
    private Function0<Unit> addCallback;
    @NotNull
    private Function1<? super byte[], Unit> receiveCallback;
    private long currentLogPointer;
    private MVMap<Long, byte[]> log;
    @NotNull
    private final MVStoreGlobalLog owner;
    @NotNull
    private final String username;
    private final String password;

    @Override
    public boolean isStarted() {
        return this.started.get() && !this.closed.get();
    }

    @NotNull
    public final Function0<Unit> getAddCallback$umn_core() {
        return this.addCallback;
    }

    public final void setAddCallback$umn_core(@NotNull Function0<Unit> function0) {
        Intrinsics.checkParameterIsNotNull(function0, (String)"<set-?>");
        this.addCallback = function0;
    }

    @NotNull
    public final Function1<byte[], Unit> getReceiveCallback$umn_core() {
        return this.receiveCallback;
    }

    public final void setReceiveCallback$umn_core(@NotNull Function1<? super byte[], Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.receiveCallback = function1;
    }

    private final void checkNotClosed() {
        boolean bl;
        boolean bl2 = bl = !this.closed.get();
        if (!bl) {
            String string = "Already closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void checkNotStarted() {
        boolean bl;
        boolean bl2 = bl = !this.started.get();
        if (!bl) {
            String string = "Already started";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public void start() {
        this.checkNotClosed();
        boolean bl = this.started.compareAndSet(false, true);
        if (!bl) {
            String string = "Already started";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = (String)this.owner.getDb().openMap("users").get((Object)this.username);
        if (string == null) {
            throw (Throwable)new InvalidUsernamePasswordException("No such user: " + this.username, null, 2, null);
        }
        String passwordHash = string;
        if (!PasswordHash.validatePassword(this.password, passwordHash)) {
            throw (Throwable)new InvalidUsernamePasswordException("Invalid password for " + this.username, null, 2, null);
        }
        this.owner.startClient$umn_core(this);
        MVMap<Long, byte[]> mVMap = this.owner.getLogMap(this.username);
        Intrinsics.checkExpressionValueIsNotNull(mVMap, (String)"owner.getLogMap(username)");
        this.log = mVMap;
        this.onNewItems$umn_core();
    }

    @Override
    public void setAddCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.checkNotStarted();
        this.addCallback = callback;
    }

    @Override
    public void setReceiverCallback(long rewind, @NotNull Function1<? super byte[], Unit> callback) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        boolean bl2 = bl = rewind >= 0L;
        if (!bl) {
            String string = "Parameter rewind: invalid value " + rewind + " - must be 0 or greater";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.checkNotStarted();
        this.currentLogPointer = rewind;
        this.receiveCallback = callback;
    }

    @Override
    public void addAsync(@NotNull byte[] record) {
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        boolean bl = this.started.get();
        if (!bl) {
            String string = "Not yet started";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.checkNotClosed();
        MVMap<Long, byte[]> mVMap = this.log;
        if (mVMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"log");
        }
        MVStoreGlobalLogKt.append(mVMap, record);
        this.addCallback.invoke();
        this.owner.fireNewItemNotification$umn_core(this.username);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.owner.close$umn_core(this);
        }
    }

    public final synchronized void onNewItems$umn_core() {
        Iterator $receiver$iv;
        Iterator iterator;
        MVMap<Long, byte[]> mVMap = this.log;
        if (mVMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"log");
        }
        Iterator iterator2 = mVMap.keyIterator((Object)this.currentLogPointer);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator2, (String)"log.keyIterator(currentLogPointer)");
        Iterator iterator3 = iterator = ($receiver$iv = iterator2);
        while (iterator3.hasNext()) {
            Object object;
            Object element$iv = iterator3.next();
            Long key = (Long)element$iv;
            MVMap<Long, byte[]> mVMap2 = this.log;
            if (mVMap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"log");
            }
            if ((object = mVMap2.get((Object)key)) == null) {
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            byte[] record = (byte[])object;
            this.receiveCallback.invoke((Object)record);
            this.currentLogPointer = key + 1L;
        }
    }

    @NotNull
    public final MVStoreGlobalLog getOwner() {
        return this.owner;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    public MVStoreGlobalLogClient(@NotNull MVStoreGlobalLog owner, @NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.owner = owner;
        this.username = username;
        this.password = password;
        this.closed = new AtomicBoolean();
        this.started = new AtomicBoolean();
        this.addCallback = addCallback.1.INSTANCE;
        this.receiveCallback = receiveCallback.1.INSTANCE;
    }
}

