/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.core;

import java.io.Closeable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a9\u0010\u0003\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u0002H\u00042\b\u0010\b\u001a\u0004\u0018\u0001H\u0005\u00a2\u0006\u0002\u0010\t\u001a'\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u0002*\u0002H\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"closeQuietly", "", "Ljava/io/Closeable;", "putOrRemove", "K", "V", "", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "tryInit", "T", "block", "Lkotlin/Function0;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function0;)Ljava/io/Closeable;", "umn-core"})
public final class UtilsKt {
    public static final <K, V> void putOrRemove(@NotNull Map<K, V> $receiver, K key, @Nullable V value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (value == null) {
            $receiver.remove(key);
        } else {
            $receiver.put(key, value);
        }
    }

    public static final void closeQuietly(@NotNull Closeable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            $receiver.close();
        }
        catch (Exception t) {
            LoggerFactory.getLogger($receiver.getClass()).warn("Failed to close " + $receiver, (Throwable)t);
        }
    }

    @NotNull
    public static final <T extends Closeable> T tryInit(@NotNull T $receiver, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            block.invoke();
        }
        catch (Throwable t) {
            try {
                $receiver.close();
            }
            catch (Exception ex) {
                t.addSuppressed(ex);
            }
        }
        return $receiver;
    }
}

