/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.core;

import com.gitlab.mvysny.umn.core.UtilityMap;
import com.gitlab.mvysny.umn.core.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0017\u0010\n\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J\u001f\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u00002\b\u0010\u0017\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/gitlab/mvysny/umn/core/InMemoryUtilityMap;", "K", "", "V", "Lcom/gitlab/mvysny/umn/core/UtilityMap;", "()V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "clear", "", "find", "key", "(Ljava/lang/Comparable;)Ljava/lang/Object;", "getLargestKey", "()Ljava/lang/Comparable;", "getSmallestKey", "isEmpty", "", "keyIterator", "", "range", "Lkotlin/ranges/ClosedRange;", "put", "value", "(Ljava/lang/Comparable;Ljava/lang/Object;)V", "values", "umn-core"})
public final class InMemoryUtilityMap<K extends Comparable<? super K>, V>
implements UtilityMap<K, V> {
    private final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<K> keyIterator(@NotNull ClosedRange<K> range) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(range, (String)"range");
        ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.map.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"map.keys");
        Iterable iterable = $receiver$iv = (Iterable)keySetView;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Comparable key;
            Comparable comparable = key = (Comparable)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"key");
            if (!range.contains(comparable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv)).iterator();
    }

    @Override
    @Nullable
    public V find(@NotNull K key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        return this.map.get(key);
    }

    @Override
    public void put(@NotNull K key, @Nullable V value) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        UtilsKt.putOrRemove(this.map, key, value);
    }

    @Override
    @Nullable
    public K getSmallestKey() {
        ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.map.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"map.keys");
        return (K)CollectionsKt.min((Iterable)keySetView);
    }

    @Override
    @Nullable
    public K getLargestKey() {
        ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.map.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"map.keys");
        return (K)CollectionsKt.max((Iterable)keySetView);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<V> values() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Set<Map.Entry<K, V>> set = this.map.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"map.entries");
        Iterable iterable = $receiver$iv = (Iterable)set;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                Comparable comparable = (Comparable)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                Comparable comparable3 = (Comparable)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        $receiver$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object v = it.getValue();
            collection.add(v);
        }
        return ((List)((Object)comparator)).iterator();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

