/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.core;

import com.gitlab.mvysny.umn.core.UtilityMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0010\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/gitlab/mvysny/umn/core/FIFOBuffer;", "T", "", "log", "Lcom/gitlab/mvysny/umn/core/UtilityMap;", "", "(Lcom/gitlab/mvysny/umn/core/UtilityMap;)V", "readLock", "Ljava/util/concurrent/locks/ReentrantLock;", "writeLock", "append", "", "item", "(Ljava/lang/Object;)V", "peek", "()Ljava/lang/Object;", "poll", "umn-core"})
public final class FIFOBuffer<T> {
    private final ReentrantLock readLock;
    private final ReentrantLock writeLock;
    private final UtilityMap<Long, T> log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void append(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        Lock lock = this.writeLock;
        lock.lock();
        try {
            Long l = this.log.getLargestKey();
            long id = (l != null ? l : 0L) + 1L;
            this.log.put((Long)((Comparable)Long.valueOf(id)), item);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T poll() {
        T t;
        Lock lock = this.readLock;
        lock.lock();
        try {
            Long l = this.log.getSmallestKey();
            if (l == null) {
                T t2 = null;
                return t2;
            }
            long lowestKey = l;
            T result = this.log.find((Long)((Comparable)Long.valueOf(lowestKey)));
            this.log.put((Long)((Comparable)Long.valueOf(lowestKey)), null);
            t = result;
        }
        finally {
            lock.unlock();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T peek() {
        T t;
        Lock lock = this.readLock;
        lock.lock();
        try {
            Long l = this.log.getSmallestKey();
            if (l == null) {
                T t2 = null;
                return t2;
            }
            long lowestKey = l;
            t = this.log.find((Long)((Comparable)Long.valueOf(lowestKey)));
        }
        finally {
            lock.unlock();
        }
        return t;
    }

    public FIFOBuffer(@NotNull UtilityMap<Long, T> log) {
        Intrinsics.checkParameterIsNotNull(log, (String)"log");
        this.log = log;
        this.readLock = new ReentrantLock();
        this.writeLock = new ReentrantLock();
    }
}

